/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest.summary.pull;

import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.fusion.schema.detail.User;
import com.atlassian.fusion.schema.detail.branch.PullRequest;
import com.atlassian.fusion.schema.detail.branch.PullRequestRef;
import com.atlassian.fusion.schema.detail.branch.Reviewer;
import com.atlassian.stash.internal.jira.rest.summary.RestDetailObject;
import com.atlassian.stash.internal.jira.rest.summary.RestRepositoryHelper;
import com.atlassian.stash.internal.jira.rest.summary.pull.AbstractRestPullRequest;
import com.atlassian.stash.internal.jira.util.UrlFactory;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Set;

public class RestPullRequestDetail
extends AbstractRestPullRequest
implements RestDetailObject<PullRequest> {
    private final com.atlassian.bitbucket.pull.PullRequest pullRequest;

    public RestPullRequestDetail(com.atlassian.bitbucket.pull.PullRequest pullRequest) {
        this.pullRequest = pullRequest;
    }

    @Override
    @Nonnull
    public PullRequest asJson(@Nonnull UrlFactory urlFactory) {
        Long commentCount = (Long)this.pullRequest.getProperties().get((Object)"commentCount");
        return new PullRequest.Builder("#" + this.pullRequest.getId(), this.pullRequest.getTitle()).status(RestPullRequestDetail.toPullRequestState(this.pullRequest.getState())).source(RestPullRequestDetail.toPullRequestRef(this.pullRequest.getFromRef(), urlFactory)).destination(RestPullRequestDetail.toPullRequestRef(this.pullRequest.getToRef(), urlFactory)).lastUpdate(this.pullRequest.getUpdatedDate()).commentCount(Math.toIntExact(commentCount == null ? 0L : commentCount)).author(RestPullRequestDetail.toUser(this.pullRequest.getAuthor().getUser(), urlFactory)).addReviewers(RestPullRequestDetail.toReviewers(this.pullRequest.getReviewers(), urlFactory)).url(urlFactory.pullRequest(this.pullRequest)).build();
    }

    @VisibleForTesting
    public com.atlassian.bitbucket.pull.PullRequest getPullRequest() {
        return this.pullRequest;
    }

    private static User toUser(ApplicationUser user, UrlFactory urlFactory) {
        return ((User.Builder)new User.Builder(user.getDisplayName()).avatar(urlFactory.userAvatar((Person)user))).build();
    }

    private static PullRequestRef toPullRequestRef(com.atlassian.bitbucket.pull.PullRequestRef ref, UrlFactory urlFactory) {
        String url = urlFactory.ref(ref.getRepository(), ref.getId());
        return new PullRequestRef.Builder(ref.getDisplayId(), url).repository(RestRepositoryHelper.asJson(ref.getRepository(), urlFactory)).build();
    }

    private static List<Reviewer> toReviewers(Set<PullRequestParticipant> participants, UrlFactory urlFactory) {
        return (List)participants.stream().map(participant -> ((Reviewer.Builder)new Reviewer.Builder(participant.getUser().getDisplayName()).avatar(urlFactory.userAvatar((Person)participant.getUser()))).approved(participant.isApproved()).build()).collect(MoreCollectors.toImmutableList());
    }
}

