/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.server.commit;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.change.CommitChange;
import com.atlassian.stash.internal.jira.listener.CommitChangeListener;
import com.atlassian.stash.internal.jira.server.config.IssueIndexingConfig;
import com.atlassian.stash.internal.jira.server.publisher.RemoteEventPublisher;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class RemoteEventIndexListener
implements CommitChangeListener {
    private final int commitsThreshold;
    private final int issuesThreshold;
    private final RemoteEventPublisher publisher;
    private final Repository repository;
    private List<CommitChange> commits;
    private Set<String> issueKeys;

    RemoteEventIndexListener(@Nonnull IssueIndexingConfig config, @Nonnull RemoteEventPublisher publisher, @Nonnull Repository repository) {
        this.publisher = Objects.requireNonNull(publisher, "publisher");
        this.repository = Objects.requireNonNull(repository, "repository");
        this.commitsThreshold = config.getCommitEventsThreshold();
        if (this.commitsThreshold > 0) {
            this.commits = new ArrayList<CommitChange>();
        }
        this.issuesThreshold = config.getIssueChangedEventsThreshold();
        if (this.issuesThreshold > 0) {
            this.issueKeys = new HashSet<String>();
        }
    }

    @Override
    public void onEnd() {
        if (this.commits != null && !this.commits.isEmpty()) {
            this.publishCommits();
        }
        if (this.issueKeys != null && !this.issueKeys.isEmpty()) {
            this.publishIssues();
        }
    }

    @Override
    public void onCommit(@Nonnull CommitChange commitChange) {
        if (this.commits == null && this.issueKeys == null) {
            return;
        }
        if (this.commits != null) {
            this.commits.add(commitChange);
            if (this.commits.size() >= this.commitsThreshold) {
                this.publishCommits();
            }
        }
        if (this.issueKeys != null) {
            this.issueKeys.addAll(commitChange.getIssueKeys());
            if (this.issueKeys.size() >= this.issuesThreshold) {
                this.publishIssues();
            }
        }
    }

    private void publishCommits() {
        this.publisher.publishCommitEvents(this.repository, this.commits);
        this.commits = null;
    }

    private void publishIssues() {
        this.publisher.publishIssueEvents(this.issueKeys, this.issueKeys.size());
        this.issueKeys = null;
    }
}

