/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.server.config;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;

public class IssueIndexingConfig {
    private static final String BRANCH_EVENT_THRESHOLD_KEY = "plugin.dev-summary.branch.events.threshold";
    private static final String COMMIT_EVENT_MESSAGE_SIZE_KEY = "plugin.dev-summary.commit.message.size";
    private static final String COMMIT_EVENT_THRESHOLD_KEY = "plugin.dev-summary.commit.events.threshold";
    private static final String ISSUE_CHANGED_EVENT_THRESHOLD_KEY = "plugin.dev-summary.issuechanged.events.threshold";
    private static final String ISSUE_COMMITS_THRESHOLD_KEY = "plugin.dev-summary.issue.commits.threshold";
    private static final String PR_EVENTS_ENABLE_KEY = "plugin.dev-summary.pr.events.enabled";
    private static final String SMART_COMMITS_DISABLED_KEY = "plugin.dev-summary.smart.commits.disabled";
    private final ApplicationPropertiesService propertiesService;

    public IssueIndexingConfig(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    public int getBranchEventsThreshold() {
        return this.propertiesService.getPluginProperty(BRANCH_EVENT_THRESHOLD_KEY, 10);
    }

    public int getCommitEventsThreshold() {
        return this.propertiesService.getPluginProperty(COMMIT_EVENT_THRESHOLD_KEY, 100);
    }

    public int getCommitMessageMaxSize() {
        return this.propertiesService.getPluginProperty(COMMIT_EVENT_MESSAGE_SIZE_KEY, 1024);
    }

    public int getIssueChangedEventsThreshold() {
        return this.propertiesService.getPluginProperty(ISSUE_CHANGED_EVENT_THRESHOLD_KEY, 100000);
    }

    public int getIssueCommitsThreshold() {
        return this.propertiesService.getPluginProperty(ISSUE_COMMITS_THRESHOLD_KEY, 100);
    }

    public boolean isPrEventTypePublishingEnabled() {
        return this.propertiesService.getPluginProperty(PR_EVENTS_ENABLE_KEY, true);
    }

    public boolean isSmartCommitsEnabled() {
        return !this.propertiesService.getPluginProperty(SMART_COMMITS_DISABLED_KEY, false);
    }
}

