/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.server.publisher;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ReadOnlyApplicationLink;
import com.atlassian.applinks.api.ReadOnlyApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.remote.ApplinkFilter;
import com.atlassian.stash.internal.jira.cloud.client.CloudIdResolvingClient;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.service.EscalatedJiraSiteConfigSupplier;
import com.google.common.base.Throwables;
import java.net.URI;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplinkFilter
implements ApplinkFilter {
    private static final long VALID_INSTANCE_CACHE_EXPIRE_TIME = 1L;
    private static final int VALID_INSTANCE_CACHE_MAX_ENTRIES = 1000;
    private static final String VALID_INSTANCE_CACHE_NAME = "com.atlassian.stash.internal.jira.cloud.client.DefaultApplinkFilter.validInstanceCache";
    private static final Logger log = LoggerFactory.getLogger(DefaultApplinkFilter.class);
    private final ReadOnlyApplicationLinkService applicationLinkService;
    private final CloudIdResolvingClient cloudIdResolvingClient;
    private final Cache<String, Boolean> jiraServerUrlCache;
    private final EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier;

    public DefaultApplinkFilter(ReadOnlyApplicationLinkService applicationLinkService, CacheFactory cacheFactory, CloudIdResolvingClient cloudIdResolvingClient, EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier) {
        this.applicationLinkService = applicationLinkService;
        this.cloudIdResolvingClient = cloudIdResolvingClient;
        this.jiraServerUrlCache = cacheFactory.getCache(VALID_INSTANCE_CACHE_NAME, null, new CacheSettingsBuilder().local().expireAfterAccess(1L, TimeUnit.DAYS).maxEntries(1000).build());
        this.jiraSiteConfigSupplier = jiraSiteConfigSupplier;
    }

    public boolean shouldFilter(String applinkId) {
        ReadOnlyApplicationLink applink = this.applicationLinkService.getApplicationLink(new ApplicationId(applinkId));
        URI applinkUri = applink.getRpcUrl();
        String applinkUrl = applinkUri.toString();
        log.debug("Checking if applink {} ({}) needs to be filtered.", (Object)applinkId, (Object)applinkUrl);
        if (!(applink.getType() instanceof JiraApplicationType)) {
            log.debug("Applink type ({}) is not jira type - not filtering.", (Object)applink.getType());
            return false;
        }
        if (this.jiraServerUrlCache.containsKey((Object)applinkUrl) && ((Boolean)this.jiraServerUrlCache.get((Object)applinkUrl)).booleanValue()) {
            log.debug("Applink with URL {} points to Jira Server - not filtering.", (Object)applinkUrl);
            return false;
        }
        List<JiraSiteConfig> configs = this.jiraSiteConfigSupplier.getAll();
        if (configs.isEmpty()) {
            log.debug("No Jira Site Configs were found - not filtering.");
            return false;
        }
        if (configs.stream().anyMatch(config -> URI.create(config.getUrl()).equals(applinkUri))) {
            log.debug("Found a Jira Site Config with matching URL - filtering.");
            return true;
        }
        boolean cloudIdsMatch = configs.stream().anyMatch(config -> {
            try {
                this.jiraServerUrlCache.put((Object)applinkUrl, (Object)false);
                return config.getCloudId().equals(this.cloudIdResolvingClient.getCloudId(applinkUrl));
            }
            catch (Exception ex) {
                this.jiraServerUrlCache.put((Object)applinkUrl, (Object)true);
                log.info("Failed to resolve cloudId for applink with URL {}, it may be because this URL points to Jira Server: {}", (Object)applinkUrl, (Object)Throwables.getRootCause((Throwable)ex).getMessage());
                return false;
            }
        });
        if (cloudIdsMatch) {
            log.debug("Found a Jira Site Config with matching cloudId - filtering.");
            return true;
        }
        log.debug("Criteria for filtering not met - not filtering.");
        return false;
    }
}

