/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.server.publisher;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.devstatus.EventEntity;
import com.atlassian.devstatus.EventInitiator;
import com.atlassian.devstatus.IssueChangedEvent;
import com.atlassian.devstatus.vcs.JiraBranchEvent;
import com.atlassian.devstatus.vcs.JiraCommitEvent;
import com.atlassian.devstatus.vcs.JiraPullRequestEvent;
import com.atlassian.devstatus.vcs.LimitExceededEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.ApplinkFilter;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.RemoteEventProducer;
import com.atlassian.event.remote.RemoteEventProducerRegistrar;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.stash.internal.jira.change.BranchChange;
import com.atlassian.stash.internal.jira.change.CommitChange;
import com.atlassian.stash.internal.jira.change.PullRequestChange;
import com.atlassian.stash.internal.jira.listener.BranchChangeListener;
import com.atlassian.stash.internal.jira.listener.PullRequestChangeListener;
import com.atlassian.stash.internal.jira.listener.RepositoryChangeListener;
import com.atlassian.stash.internal.jira.server.config.IssueIndexingConfig;
import com.atlassian.stash.internal.jira.util.CommitUserEnricher;
import com.atlassian.stash.internal.jira.util.CommitUserEnricherFactory;
import com.atlassian.stash.internal.jira.util.UrlFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteEventPublisher
implements RemoteEventProducer,
LifecycleAware,
PullRequestChangeListener,
BranchChangeListener,
RepositoryChangeListener {
    private static final Logger log = LoggerFactory.getLogger(RemoteEventPublisher.class);
    private static final Pattern SMART_COMMIT = Pattern.compile("(?:^|\\s)#([A-Za-z][A-Za-z\\-]*)");
    private final AuthenticationContext authenticationContext;
    private final IssueIndexingConfig config;
    private final EventPublisher eventPublisher;
    private final ApplinkFilter applinkFilter;
    private final RemoteEventProducerRegistrar registrar;
    private final UrlFactory urlFactory;
    private final CommitUserEnricherFactory userEnricherFactory;

    public RemoteEventPublisher(AuthenticationContext authenticationContext, ApplinkFilter applinkFilter, IssueIndexingConfig config, EventPublisher eventPublisher, RemoteEventProducerRegistrar registrar, UrlFactory urlFactory, CommitUserEnricherFactory userEnricherFactory) {
        this.authenticationContext = authenticationContext;
        this.applinkFilter = applinkFilter;
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.registrar = registrar;
        this.urlFactory = urlFactory;
        this.userEnricherFactory = userEnricherFactory;
    }

    public ApplinkFilter getApplinkFilter() {
        return this.applinkFilter;
    }

    public void onStart() {
        this.registrar.register((RemoteEventProducer)this);
    }

    public void onStop() {
        this.registrar.unregister((RemoteEventProducer)this);
    }

    @Nonnull
    public Iterable<Class<? extends RemoteEvent>> produces() {
        return ImmutableList.of(IssueChangedEvent.class, LimitExceededEvent.class, JiraBranchEvent.class, JiraCommitEvent.class, JiraPullRequestEvent.class);
    }

    @Override
    public void onBranchChanges(@Nonnull Repository repository, @Nonnull Collection<BranchChange> branchChanges) {
        Set<String> issues = branchChanges.stream().map(BranchChange::getIssueKeys).flatMap(Collection::stream).collect(Collectors.toSet());
        this.publishIssueEvents(issues);
        this.publishBranchEvents(repository, branchChanges);
    }

    @Override
    public void onPullRequestUpdated(@Nonnull PullRequestChange pullRequestChange) {
        Set<String> issueKeys = pullRequestChange.getIssueKeys();
        PullRequest pullRequest = pullRequestChange.getPullRequest();
        PullRequestAction action = pullRequestChange.getAction();
        switch (action) {
            case DELETED: {
                log.debug("Incorrect call to onPullRequestUpdated. Delegating to onPullRequestDeleted");
                this.onPullRequestDeleted(pullRequest.getToRef().getRepository(), pullRequest.getId(), issueKeys);
                break;
            }
            case DECLINED: 
            case MERGED: 
            case OPENED: 
            case REOPENED: 
            case RESCOPED: 
            case UPDATED: {
                this.publishIssueEvents(issueKeys);
                this.publishPullRequestEvent(this.toPullRequestEventType(action), pullRequest, issueKeys);
            }
        }
    }

    @Override
    public void onPullRequestDeleted(@Nonnull Repository repository, @Nonnull Long pullRequestId, @Nonnull Set<String> linkedIssues) {
        this.publishIssueEvents(linkedIssues, Integer.MAX_VALUE);
    }

    @Override
    public void onRepositoryDeleted(@Nonnull Repository repository, @Nonnull Set<String> linkedIssues) {
        this.publishIssueEvents(linkedIssues, Integer.MAX_VALUE);
    }

    private void publishBranchEvents(@Nonnull Repository repository, @Nonnull Collection<BranchChange> refChanges) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(refChanges, "refChanges");
        int maxEvents = this.config.getBranchEventsThreshold();
        if (refChanges.isEmpty() || maxEvents <= 0) {
            return;
        }
        EventInitiator initiator = this.getCurrentInitator().orElse(EventInitiator.EMPTY_INITIATOR);
        List branchEvents = (List)refChanges.stream().map(refChange -> this.toBranchEvent(repository, initiator, (BranchChange)refChange)).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
        int droppedCount = branchEvents.size() - maxEvents;
        if (droppedCount > 0) {
            this.publish(new LimitExceededEvent(JiraBranchEvent.class.getSimpleName(), droppedCount));
            log.debug("Limit exceeded - {} branch events dropped", (Object)droppedCount);
        }
        Iterables.limit((Iterable)branchEvents, (int)maxEvents).forEach(this::publish);
    }

    public void publishCommitEvents(@Nonnull Repository repository, @Nonnull Collection<CommitChange> commitChanges) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(commitChanges, "commitChanges");
        int maxEvents = this.config.getCommitEventsThreshold();
        if (commitChanges.isEmpty() || maxEvents <= 0) {
            return;
        }
        int droppedCount = commitChanges.size() - maxEvents;
        if (droppedCount > 0) {
            this.publish(new LimitExceededEvent(JiraCommitEvent.class.getSimpleName(), droppedCount));
            log.debug("Limit exceeded - {} Jira commit events dropped", (Object)droppedCount);
        }
        Function<Commit, String> messageExtractor = this.smartCommitMessage();
        CommitUserEnricher userEnricher = this.userEnricherFactory.create();
        commitChanges.stream().limit(maxEvents).map(commitChange -> this.toCommitEvent(repository, messageExtractor, userEnricher, (CommitChange)commitChange)).forEach(this::publish);
    }

    public void publishIssueEvents(@Nonnull Set<String> issueKeys) {
        this.publishIssueEvents(issueKeys, this.config.getIssueChangedEventsThreshold());
    }

    public void publishIssueEvents(@Nonnull Set<String> issueKeys, int maxEvents) {
        if (Objects.requireNonNull(issueKeys, "issueKeys").isEmpty() || maxEvents <= 0) {
            return;
        }
        int droppedCount = issueKeys.size() - maxEvents;
        if (droppedCount > 0) {
            this.publish(new LimitExceededEvent(IssueChangedEvent.class.getSimpleName(), droppedCount));
            log.debug("Limit exceeded - {} issue changed events dropped", (Object)droppedCount);
        }
        this.publish(new IssueChangedEvent((Collection)issueKeys.stream().limit(maxEvents).collect(MoreCollectors.toImmutableSet())));
    }

    public void publishPullRequestEvent(@Nonnull JiraPullRequestEvent.Type type, @Nonnull PullRequest pullRequest, @Nonnull Set<String> issueKeys) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(issueKeys, "issueKeys");
        if (!issueKeys.isEmpty() && this.config.isPrEventTypePublishingEnabled()) {
            this.publish(new JiraPullRequestEvent(this.getCurrentInitator().orElse(EventInitiator.EMPTY_INITIATOR), this.toEventEntity(pullRequest), issueKeys, type));
        }
    }

    private Optional<EventInitiator> getCurrentInitator() {
        return Optional.ofNullable(this.authenticationContext.getCurrentUser()).map(this::getEventInitiator);
    }

    private EventInitiator getEventInitiator(Person user) {
        String displayName = null;
        URI userUrl = null;
        if (user instanceof ApplicationUser) {
            displayName = ((ApplicationUser)user).getDisplayName();
            userUrl = URI.create(this.urlFactory.user((ApplicationUser)user));
        }
        return new EventInitiator(user.getName(), displayName, userUrl, user.getEmailAddress() == null ? Collections.emptyList() : Collections.singleton(user.getEmailAddress()), URI.create(this.urlFactory.userAvatar(user)));
    }

    private void publish(Object o) {
        log.debug("Publishing remote event: {}", o);
        this.eventPublisher.publish(o);
    }

    private Function<Commit, String> smartCommitMessage() {
        if (this.config.isSmartCommitsEnabled()) {
            int maxSize = this.config.getCommitMessageMaxSize();
            return commit -> {
                String message = commit.getMessage();
                if (message != null && SMART_COMMIT.matcher(message).find()) {
                    return StringUtils.truncate((String)message, (int)maxSize);
                }
                return "";
            };
        }
        return commit -> "";
    }

    private JiraBranchEvent toBranchEvent(Repository repository, EventInitiator initiator, BranchChange branchChange) {
        RefChange refChange = branchChange.getRefChange();
        Set<String> issueKeys = branchChange.getIssueKeys();
        if (issueKeys.isEmpty()) {
            return null;
        }
        return new JiraBranchEvent(initiator, this.toEventEntity(repository, refChange), issueKeys, refChange.getFromHash(), refChange.getToHash(), RemoteEventPublisher.toBranchEventType(refChange.getType()));
    }

    private static JiraBranchEvent.Type toBranchEventType(RefChangeType type) {
        switch (type) {
            case ADD: {
                return JiraBranchEvent.Type.CREATE;
            }
            case DELETE: {
                return JiraBranchEvent.Type.DELETE;
            }
            case UPDATE: {
                return JiraBranchEvent.Type.MODIFY;
            }
        }
        return null;
    }

    private JiraPullRequestEvent.Type toPullRequestEventType(PullRequestAction action) {
        switch (action) {
            case COMMENTED: {
                return JiraPullRequestEvent.Type.COMMENT;
            }
            case DECLINED: {
                return JiraPullRequestEvent.Type.DECLINE;
            }
            case MERGED: {
                return JiraPullRequestEvent.Type.MERGE;
            }
            case OPENED: {
                return JiraPullRequestEvent.Type.CREATE;
            }
            case REOPENED: {
                return JiraPullRequestEvent.Type.REOPEN;
            }
            case RESCOPED: 
            case UPDATED: {
                return JiraPullRequestEvent.Type.MODIFY;
            }
        }
        throw new IllegalArgumentException(String.format("No mapping of [%s] to Jira Pull Request Event Type ", action));
    }

    private JiraCommitEvent toCommitEvent(Repository repository, Function<Commit, String> messageExtractor, CommitUserEnricher userEnricher, CommitChange commitChange) {
        Commit commit = commitChange.getCommit();
        EventInitiator initiator = this.getCurrentInitator().orElseGet(() -> this.getEventInitiator(userEnricher.enrich(commit.getAuthor())));
        return new JiraCommitEvent.Builder().withInitiator(initiator).withEntity(this.toEventEntity(repository, commit)).withIssueKeys(commitChange.getIssueKeys()).withType(commitChange.getType().getEventType()).withAuthorDate(commit.getAuthorTimestamp()).withAuthor(RemoteEventPublisher.toPerson(commit.getAuthor())).withMergeCommit(commit.getParents().size() > 1).withCommitMessage(messageExtractor.apply(commit)).build();
    }

    private EventEntity toEventEntity(PullRequest pullRequest) {
        return EventEntity.newNonUniqueEntity((String)("#" + pullRequest.getId()), (URI)URI.create(this.urlFactory.pullRequest(pullRequest)));
    }

    private EventEntity toEventEntity(Repository repository, Commit commit) {
        return EventEntity.newUniqueEntity((String)commit.getId(), (String)commit.getDisplayId(), (URI)URI.create(this.urlFactory.commit(repository, commit.getId())));
    }

    private EventEntity toEventEntity(Repository repository, RefChange refChange) {
        return EventEntity.newNonUniqueEntity((String)refChange.getRef().getDisplayId(), (URI)URI.create(this.urlFactory.ref(repository, refChange.getRef().getId())));
    }

    private static com.atlassian.devstatus.Person toPerson(Person person) {
        return new com.atlassian.devstatus.Person(person.getName(), person.getEmailAddress());
    }
}

