/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.smart;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.stash.internal.jira.server.config.IssueIndexingConfig;
import jakarta.annotation.Nonnull;
import java.util.Map;

public class SmartCommitsCondition
implements Condition {
    private static final String APP_LINK_CONTEXT_KEY = "applicationLink";
    private static final String SMART_COMMITS_CAPABILITY = "smart-commit-consumer";
    private IssueIndexingConfig issueIndexingConfig;
    private LinkedApplicationCapabilities linkedApplicationCapabilities;

    public SmartCommitsCondition(@Nonnull IssueIndexingConfig issueIndexingConfig, @Nonnull LinkedApplicationCapabilities linkedApplicationCapabilities) {
        this.issueIndexingConfig = issueIndexingConfig;
        this.linkedApplicationCapabilities = linkedApplicationCapabilities;
    }

    public void init(Map<String, String> map) {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationLink applicationLink = (ApplicationLink)context.get(APP_LINK_CONTEXT_KEY);
        return applicationLink != null && this.issueIndexingConfig.isSmartCommitsEnabled() && this.isAnyCapableApplicationLinked(applicationLink);
    }

    private boolean isAnyCapableApplicationLinked(ApplicationLink applicationLink) {
        return this.linkedApplicationCapabilities.capableOf(SMART_COMMITS_CAPABILITY).stream().map(LinkedAppWithCapabilities::getApplicationLinkId).anyMatch(appId -> applicationLink.getId().get().equals(appId));
    }
}

