/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.summary;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.jira.index.IndexResult;
import com.atlassian.stash.internal.jira.index.JiraIndexService;
import com.atlassian.stash.internal.jira.rest.summary.RestBranchesDetail;
import com.atlassian.stash.internal.jira.rest.summary.RestDetailObject;
import com.atlassian.stash.internal.jira.rest.summary.repository.RestRepositoriesDetail;
import com.atlassian.stash.internal.jira.summary.IssueSummary;
import com.atlassian.stash.internal.jira.summary.SummaryService;
import com.atlassian.stash.internal.jira.summary.SummaryType;
import com.atlassian.stash.internal.jira.summary.branch.BranchSummaryService;
import com.atlassian.stash.internal.jira.summary.pull.PullRequestSummaryService;
import com.atlassian.stash.internal.jira.summary.repo.RepositorySummaryService;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class DefaultSummaryService
implements SummaryService {
    private final BranchSummaryService branchSummaryService;
    private final JiraIndexService indexService;
    private final PullRequestSummaryService pullRequestSummaryService;
    private final RepositorySummaryService repositorySummaryService;

    public DefaultSummaryService(BranchSummaryService branchSummaryService, JiraIndexService indexService, PullRequestSummaryService pullRequestSummaryService, RepositorySummaryService repositorySummaryService) {
        this.branchSummaryService = branchSummaryService;
        this.indexService = indexService;
        this.pullRequestSummaryService = pullRequestSummaryService;
        this.repositorySummaryService = repositorySummaryService;
    }

    @Override
    @Nonnull
    public RestDetailObject getDetails(@Nonnull SummaryType type, @Nonnull Collection<String> issueKeys) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(issueKeys, "issueKeys");
        switch (type) {
            case REPOSITORY: {
                return new RestRepositoriesDetail(this.repositorySummaryService.getDetails((Iterable<String>)issueKeys));
            }
            case BRANCH: 
            case PULL_REQUEST: {
                Map<String, List<IndexResult>> indexResults = this.indexService.find(issueKeys);
                return new RestBranchesDetail(this.branchSummaryService.getDetails(indexResults), this.pullRequestSummaryService.getDetails(indexResults));
            }
        }
        throw new IllegalArgumentException("Method does not support summaries of type: " + String.valueOf((Object)type));
    }

    @Override
    @Nonnull
    public List<IssueSummary> getSummaries(@Nonnull Iterable<String> issueKeys) {
        Objects.requireNonNull(issueKeys, "issueKeys");
        try (Timer ignored = TimerUtils.start((String)String.format("Jira dev integration: Get summaries for %s issues", Iterables.size(issueKeys)));){
            Map<String, List<IndexResult>> indexResults = this.indexService.find(issueKeys);
            List list = (List)Stream.concat(Stream.concat(this.repositorySummaryService.getSummaries(issueKeys), this.branchSummaryService.getSummaries(indexResults)), this.pullRequestSummaryService.getSummaries(indexResults)).collect(MoreCollectors.toImmutableList());
            return list;
        }
    }
}

