/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.summary;

import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Objects;

public enum SummaryType {
    BRANCH("branch"),
    PULL_REQUEST("pullrequest"),
    REPOSITORY("repository");

    private final String value;

    private SummaryType(String value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nonnull
    public static SummaryType fromString(@Nonnull String value) {
        String lowerValue = value.toLowerCase(Locale.ROOT);
        for (SummaryType type : SummaryType.values()) {
            if (!type.getValue().equals(lowerValue)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unsupported summary type: " + value);
    }
}

