/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.summary.branch;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.jira.index.IndexResult;
import com.atlassian.stash.internal.jira.index.branch.IndexedBranch;
import com.atlassian.stash.internal.jira.index.pull.IndexedPullRequest;
import com.atlassian.stash.internal.jira.rest.summary.RestResultSummary;
import com.atlassian.stash.internal.jira.rest.summary.RestSummaryObject;
import com.atlassian.stash.internal.jira.rest.summary.branch.RestBranchDetail;
import com.atlassian.stash.internal.jira.summary.IssueSummary;
import com.atlassian.stash.internal.jira.summary.SubjectSummaryService;
import com.atlassian.stash.internal.jira.summary.branch.BranchIssueSummary;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchSummaryService
implements SubjectSummaryService<RestBranchDetail, Map<String, List<IndexResult>>> {
    private static final Logger log = LoggerFactory.getLogger(BranchSummaryService.class);
    private final PermissionService permissionService;
    private final PullRequestService pullRequestService;

    public BranchSummaryService(PermissionService permissionService, PullRequestService pullRequestService) {
        this.permissionService = permissionService;
        this.pullRequestService = pullRequestService;
    }

    @Override
    @Nonnull
    public List<RestBranchDetail> getDetails(@Nonnull Map<String, List<IndexResult>> results) {
        return (List)Objects.requireNonNull(results, "results").values().stream().flatMap(Collection::stream).map(this::toIndexedBranch).filter(Objects::nonNull).collect(Collectors.groupingBy(IndexResult::getRepository, Collectors.mapping(Function.identity(), MoreCollectors.toImmutableSet()))).entrySet().stream().map(entry -> {
            boolean canWrite = this.permissionService.hasRepositoryPermission((Repository)entry.getKey(), Permission.REPO_WRITE);
            return ImmutablePair.of((Object)canWrite, (Object)((Set)entry.getValue()));
        }).flatMap(pair -> ((Set)pair.getValue()).stream().map(result -> new RestBranchDetail(result.getRepository(), result.getRefId(), (Boolean)pair.getKey()))).sorted(Comparator.comparing(RestBranchDetail::getRefId)).collect(MoreCollectors.toImmutableList());
    }

    @Override
    @Nonnull
    public Stream<IssueSummary> getSummaries(@Nonnull Map<String, List<IndexResult>> results) {
        try (Timer ignored = TimerUtils.start((String)String.format("Jira dev integration: Getting branch summaries for %s issue keys", results.size()));){
            Stream<IssueSummary> stream = results.keySet().stream().map(issueKey -> new BranchIssueSummary((String)issueKey, this.toSummaryObjects((List)results.get(issueKey))));
            return stream;
        }
    }

    private IndexedBranch toIndexedBranch(IndexResult result) {
        if (result instanceof IndexedBranch) {
            return (IndexedBranch)result;
        }
        if (result instanceof IndexedPullRequest) {
            IndexedPullRequest indexedPullRequest = (IndexedPullRequest)result;
            try {
                PullRequest pullRequest = this.pullRequestService.getById(indexedPullRequest.getRepository().getId(), indexedPullRequest.getId());
                if (pullRequest != null && pullRequest.isOpen()) {
                    return BranchSummaryService.toIndexedBranch(pullRequest.getFromRef().getRepository(), indexedPullRequest);
                }
            }
            catch (AuthorisationException e) {
                log.debug("Could not load pull request [{}/{}] to convert to indexed branch", (Object)indexedPullRequest.getRepository(), (Object)indexedPullRequest.getId());
            }
        }
        return null;
    }

    private Collection<RestSummaryObject> toSummaryObjects(@Nullable List<IndexResult> results) {
        return results == null ? Collections.emptyList() : (Collection)results.stream().map(result -> {
            IndexedPullRequest pullRequest;
            if (result instanceof IndexedBranch) {
                return (IndexedBranch)result;
            }
            if (result instanceof IndexedPullRequest && (pullRequest = (IndexedPullRequest)result).getState() == PullRequestState.OPEN) {
                return BranchSummaryService.toIndexedBranch(pullRequest.getRepository(), pullRequest);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(result -> result.getRepository().getId() + 2 + result.getRefId())).entrySet().stream().flatMap(entry -> {
            IndexResult result = ((List)entry.getValue()).stream().sorted(Comparator.comparing(IndexResult::getLastUpdated)).findFirst().orElse(null);
            return result == null ? Stream.empty() : Stream.of(result);
        }).collect(Collectors.groupingBy(IndexResult::getRepository)).entrySet().stream().sorted(BranchSummaryService::nonForksFirst).map(entry -> new RestResultSummary((Repository)entry.getKey(), (List)entry.getValue())).collect(MoreCollectors.toImmutableList());
    }

    private static IndexedBranch toIndexedBranch(Repository repository, IndexedPullRequest pullRequest) {
        return new IndexedBranch(repository, pullRequest.getIssueKey(), pullRequest.getRefId(), pullRequest.getLastUpdated());
    }

    private static int nonForksFirst(Map.Entry<Repository, List<IndexResult>> a, Map.Entry<Repository, List<IndexResult>> b) {
        Repository left = a.getKey();
        Repository right = b.getKey();
        if (left.isFork() == right.isFork()) {
            return left.getId() - right.getId();
        }
        return left.isFork() ? 1 : -1;
    }
}

