/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.summary.pull;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.jira.index.IndexResult;
import com.atlassian.stash.internal.jira.index.pull.IndexedPullRequest;
import com.atlassian.stash.internal.jira.rest.summary.RestSummaryObject;
import com.atlassian.stash.internal.jira.rest.summary.pull.RestPullRequestDetail;
import com.atlassian.stash.internal.jira.rest.summary.pull.RestPullRequestSummary;
import com.atlassian.stash.internal.jira.summary.IssueSummary;
import com.atlassian.stash.internal.jira.summary.SubjectSummaryService;
import com.atlassian.stash.internal.jira.summary.pull.PullRequestIssueSummary;
import com.google.common.collect.Ordering;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PullRequestSummaryService
implements SubjectSummaryService<RestPullRequestDetail, Map<String, List<IndexResult>>> {
    private static final Comparator<IndexedPullRequest> BY_STATE_THEN_ID = Ordering.explicit((Object)PullRequestState.OPEN, (Object[])new PullRequestState[]{PullRequestState.MERGED, PullRequestState.DECLINED}).onResultOf(IndexedPullRequest::getState).thenComparing(IndexedPullRequest::getId);
    private final PullRequestService pullRequestService;

    public PullRequestSummaryService(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    @Override
    @Nonnull
    public List<RestPullRequestDetail> getDetails(@Nonnull Map<String, List<IndexResult>> results) {
        return (List)PullRequestSummaryService.streamOrderedPullRequests(results).flatMap(indexResult -> {
            try {
                PullRequest pullRequest = this.pullRequestService.getById(indexResult.getRepository().getId(), indexResult.getId());
                if (pullRequest != null) {
                    return Stream.of(new RestPullRequestDetail(pullRequest));
                }
            }
            catch (AuthorisationException authorisationException) {
                // empty catch block
            }
            return Stream.empty();
        }).collect(MoreCollectors.toImmutableList());
    }

    @Override
    @Nonnull
    public Stream<IssueSummary> getSummaries(@Nonnull Map<String, List<IndexResult>> results) {
        try (Timer ignored = TimerUtils.start((String)String.format("Jira dev integration: Getting pull request summaries for %s issue keys", results.size()));){
            Map<String, List<IndexedPullRequest>> pullRequests = PullRequestSummaryService.streamOrderedPullRequests(results).collect(Collectors.groupingBy(IndexResult::getIssueKey));
            Stream<IssueSummary> stream = results.keySet().stream().map(issueKey -> new PullRequestIssueSummary((String)issueKey, (Collection<RestSummaryObject>)PullRequestSummaryService.toSummaryObjects((List)pullRequests.get(issueKey))));
            return stream;
        }
    }

    private static Stream<IndexedPullRequest> streamOrderedPullRequests(@Nonnull Map<String, List<IndexResult>> results) {
        return Objects.requireNonNull(results, "results").values().stream().flatMap(Collection::stream).filter(result -> result instanceof IndexedPullRequest).map(IndexedPullRequest.class::cast).sorted(BY_STATE_THEN_ID).distinct();
    }

    private static List<RestSummaryObject> toSummaryObjects(List<IndexedPullRequest> results) {
        return results == null ? Collections.emptyList() : (List)results.stream().map(RestPullRequestSummary::new).collect(MoreCollectors.toImmutableList());
    }
}

