/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.summary.repo;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.ChangesetsRequest;
import com.atlassian.bitbucket.commit.CommitEnricher;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.SimpleChangeset;
import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.dmz.idx.DmzCommitIndex;
import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.jira.rest.summary.RestSummaryObject;
import com.atlassian.stash.internal.jira.rest.summary.commit.RestCommitDetail;
import com.atlassian.stash.internal.jira.rest.summary.commit.RestCommitSummary;
import com.atlassian.stash.internal.jira.server.config.IssueIndexingConfig;
import com.atlassian.stash.internal.jira.summary.IssueSummary;
import com.atlassian.stash.internal.jira.summary.SubjectSummaryService;
import com.atlassian.stash.internal.jira.summary.repo.RepositoryIssueSummary;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class RepositorySummaryService
implements SubjectSummaryService<RestCommitDetail, Iterable<String>> {
    private static final boolean CASE_SENSITIVE = true;
    private static final int MAX_FILE_CHANGES = 100;
    private static final String JIRA_KEY_FIELD = "jira-key";
    private final Anonymous2LORequestVerifier anonymous2LORequestVerifier;
    private final CommitEnricher commitEnricher;
    private final DmzCommitIndex commitIndex;
    private final CommitService commitService;
    private final IssueIndexingConfig config;

    public RepositorySummaryService(Anonymous2LORequestVerifier anonymous2LORequestVerifier, CommitEnricher commitEnricher, DmzCommitIndex commitIndex, CommitService commitService, IssueIndexingConfig config) {
        this.anonymous2LORequestVerifier = anonymous2LORequestVerifier;
        this.commitEnricher = commitEnricher;
        this.commitIndex = commitIndex;
        this.commitService = commitService;
        this.config = config;
    }

    @Override
    @Nonnull
    public List<RestCommitDetail> getDetails(@Nonnull Iterable<String> issueKeys) {
        Map commitsByRepo = this.mapCommitsByKey(issueKeys).values().stream().flatMap(Page::stream).flatMap(commit -> commit.getRepositories().stream().filter(RepositorySummaryService.nonUniqueForks(commit)).map(repository -> ImmutablePair.of((Object)repository, (Object)commit.getId()))).collect(Collectors.groupingBy(ImmutablePair::getLeft, Collectors.mapping(ImmutablePair::getRight, MoreCollectors.toImmutableSet())));
        return (List)commitsByRepo.entrySet().stream().map(entry -> {
            Repository repository = (Repository)entry.getKey();
            Set commitIds = (Set)entry.getValue();
            ChangesetsRequest request = new ChangesetsRequest.Builder(repository).commitIds((Iterable)commitIds).maxChangesPerCommit(100).ignoreMissing(true).build();
            Page<Changeset> changesets = this.enrichToCommit(repository, (Page<Changeset>)this.commitService.getChangesets(request, PageUtils.newRequest((int)0, (int)commitIds.size())));
            return new RestCommitDetail(repository, (List)changesets.stream().collect(MoreCollectors.toImmutableList()));
        }).collect(MoreCollectors.toImmutableList());
    }

    @Override
    @Nonnull
    public Stream<IssueSummary> getSummaries(@Nonnull Iterable<String> issueKeys) {
        try (Timer ignored = TimerUtils.start((String)String.format("Jira dev integration: Getting repository summaries for %s issue keys", Iterables.size(issueKeys)));){
            Stream<IssueSummary> stream = this.mapCommitsByKey(issueKeys).entrySet().stream().map(entry -> new RepositoryIssueSummary((String)entry.getKey(), RepositorySummaryService.toCommitSummary((Page<IndexedCommit>)((Page)entry.getValue()))));
            return stream;
        }
    }

    private Page<Changeset> enrichToCommit(Repository repository, Page<Changeset> page) {
        Map toBeEnriched = page.stream().collect(Collectors.toMap(changeset -> changeset.getToCommit().getId(), Function.identity()));
        Page enriched = this.commitEnricher.enrichPage(repository, page.transform(Changeset::getToCommit), null);
        return enriched.transform(commit -> {
            Changeset original = (Changeset)toBeEnriched.get(commit.getId());
            return new SimpleChangeset.Builder(commit).changes(original.getChanges()).fromCommit(original.getFromCommit()).build();
        });
    }

    private Page<IndexedCommit> getCommits(String issueKey, PageRequest pageRequest) {
        if (this.anonymous2LORequestVerifier.isValid("REPO_READ")) {
            return this.commitIndex.findByPropertyUnauthenticated(JIRA_KEY_FIELD, issueKey.toUpperCase(Locale.US), true, pageRequest);
        }
        return this.commitIndex.findByProperty(JIRA_KEY_FIELD, issueKey.toUpperCase(Locale.US), true, pageRequest);
    }

    private Map<String, Page<IndexedCommit>> mapCommitsByKey(Iterable<String> issueKeys) {
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.config.getIssueCommitsThreshold());
        return (Map)MoreStreams.streamIterable(issueKeys).collect(MoreCollectors.toImmutableMap(Function.identity(), issueKey -> this.getCommits((String)issueKey, pageRequest)));
    }

    private static List<RestSummaryObject> toCommitSummary(Page<IndexedCommit> commits) {
        return (List)commits.stream().flatMap(commit -> commit.getRepositories().stream().map(repository -> ImmutablePair.of((Object)repository, (Object)commit))).collect(Collectors.groupingBy(ImmutablePair::getLeft, Collectors.mapping(ImmutablePair::getRight, MoreCollectors.toImmutableList()))).entrySet().stream().map(entry -> new RestCommitSummary((Repository)entry.getKey(), (List)entry.getValue())).collect(MoreCollectors.toImmutableList());
    }

    private static Predicate<Repository> nonUniqueForks(IndexedCommit commit) {
        return repository -> !repository.isFork() || !commit.getRepositories().contains(repository.getOrigin());
    }
}

