/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.util;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.stash.internal.jira.util.CommitUserEnricher;
import com.atlassian.stash.internal.jira.util.CommitUserEnricherFactory;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.annotation.Nonnull;

public class CachingCommitUserEnricherFactory
implements CommitUserEnricherFactory {
    private static final long MAXIMUM_SIZE = 1000L;
    private final UserService userService;

    public CachingCommitUserEnricherFactory(UserService userService) {
        this.userService = userService;
    }

    @Override
    public CommitUserEnricher create() {
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Person, Person>(){

            public Person load(@Nonnull Person person) {
                ApplicationUser user = CachingCommitUserEnricherFactory.this.userService.findUserByEmail(person.getEmailAddress());
                if (user == null) {
                    user = CachingCommitUserEnricherFactory.this.userService.findUserByNameOrEmail(person.getName());
                }
                return user == null ? person : user;
            }
        });
        return new CachingCommitUserEnricher((LoadingCache<Person, Person>)cache);
    }

    private static class CachingCommitUserEnricher
    implements CommitUserEnricher {
        private final LoadingCache<Person, Person> cache;

        private CachingCommitUserEnricher(LoadingCache<Person, Person> cache) {
            this.cache = cache;
        }

        @Override
        public Person enrich(Person person) {
            return (Person)this.cache.getUnchecked((Object)person);
        }
    }
}

