/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.util;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import jakarta.annotation.Nonnull;

public class UrlFactory {
    private final AvatarService avatarService;
    private final NavBuilder navBuilder;

    public UrlFactory(AvatarService avatarService, NavBuilder navBuilder) {
        this.avatarService = avatarService;
        this.navBuilder = navBuilder;
    }

    @Nonnull
    public String commit(@Nonnull Commit commit) {
        return this.commitBuilder(commit.getRepository(), commit.getId()).buildConfigured();
    }

    @Nonnull
    public String commit(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.commitBuilder(repository, commitId).buildConfigured();
    }

    @Nonnull
    public String createPullRequest(@Nonnull Repository repository, @Nonnull String branchId) {
        return this.repoBuilder(repository).createPullRequest().sourceBranch(branchId).buildConfigured();
    }

    @Nonnull
    public String fileAtCommit(@Nonnull Commit commit, @Nonnull Path path) {
        return this.commitBuilder(commit.getRepository(), commit.getId()).change(path).buildConfigured();
    }

    @Nonnull
    public String projectAvatar(@Nonnull Project project) {
        return this.avatarService.getUrlForProject(project, new AvatarRequest(true, 32, true));
    }

    @Nonnull
    public String pullRequest(@Nonnull PullRequest pullRequest) {
        return this.repoBuilder(pullRequest.getToRef().getRepository()).pullRequest(pullRequest.getId()).buildConfigured();
    }

    @Nonnull
    public String repository(@Nonnull Repository repository) {
        return this.repoBuilder(repository).buildConfigured();
    }

    @Nonnull
    public String ref(@Nonnull Repository repository, @Nonnull String ref) {
        return this.repoBuilder(repository).commits().until(ref).buildConfigured();
    }

    @Nonnull
    public String user(@Nonnull ApplicationUser user) {
        return this.navBuilder.user(user).buildConfigured();
    }

    @Nonnull
    public String userAvatar(@Nonnull Person person) {
        boolean useHttps = this.navBuilder.buildBaseUrl().startsWith("https");
        return this.avatarService.getUrlForPerson(person, new AvatarRequest(useHttps, 128, true));
    }

    @Nonnull
    private NavBuilder.Commit commitBuilder(@Nonnull Repository repository, @Nonnull String commitId) {
        return this.repoBuilder(repository).commit(commitId);
    }

    @Nonnull
    private NavBuilder.Repo repoBuilder(@Nonnull Repository repository) {
        return this.navBuilder.repo(repository);
    }
}

