/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mesh;

import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.dmz.server.MinimalDataStore;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RepositoryIdUtils {
    private static final Pattern PATTERN_LENIENT_REPO_ID = Pattern.compile("(p|ds)/(?<partitionOrStore>[0-9a-f]+)/h/(?<hierarchy>[0-9a-z]{20,})/r/(?<repository>[\\d]+)(\\?.*q=(?<quarantine>[0-9a-z]+))?");

    public static int getLocalRepositoryId(@Nonnull String remoteId) {
        Objects.requireNonNull(remoteId, "remoteId");
        Matcher matcher = PATTERN_LENIENT_REPO_ID.matcher(remoteId);
        String idString = null;
        if (matcher.find()) {
            idString = matcher.group("repository");
        } else if (remoteId.startsWith("path:")) {
            int index;
            int endIndex = remoteId.lastIndexOf(63);
            if (endIndex != -1) {
                remoteId = remoteId.substring(0, endIndex);
            }
            if ((index = remoteId.lastIndexOf(47)) > 0 && index < remoteId.length() - 1) {
                idString = remoteId.substring(index + 1);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)idString)) {
            try {
                return Integer.parseInt(idString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Nonnull
    public static String getRepositoryId(DmzRepository repository) {
        if (repository.isRemote()) {
            return RemoteRepositoryId.format((DmzRepository)repository);
        }
        long dataStoreId = repository.getDataStore().map(MinimalDataStore::getId).orElse(0L);
        return RepositoryIdUtils.getSidecarRepositoryId(dataStoreId, repository.getHierarchyId(), repository.getId());
    }

    @Nonnull
    public static String getSidecarRepositoryId(long dataStoreId, @Nonnull String hierarchyId, int repositoryId) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        return "ds/" + dataStoreId + "/h/" + hierarchyId + "/r/" + repositoryId;
    }
}

