/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mesh.support;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitInfo;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class GitInfo {
    private final String current;
    private final String startup;

    private GitInfo(@Nonnull String current, @Nonnull String startup) {
        this.current = Objects.requireNonNull(current, "current");
        this.startup = Objects.requireNonNull(startup, "startup");
    }

    @Nonnull
    public static GitInfo toGitInfo(@Nonnull RpcGitInfo rpc) {
        Objects.requireNonNull(rpc, "rpc");
        return new GitInfo(rpc.getCurrentVersion(), rpc.getStartupVersion());
    }

    @Nonnull
    public String getCurrent() {
        return this.current;
    }

    @Nonnull
    public String getStartup() {
        return this.startup;
    }
}

