/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mesh.support;

import com.atlassian.bitbucket.internal.mesh.support.GitInfo;
import com.atlassian.bitbucket.internal.mesh.support.TicketInfo;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetSupportInfoResponse;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Objects;

public class SupportInfo {
    private final GitInfo gitInfo;
    private final Collection<TicketInfo> ticketInfo;

    private SupportInfo(@Nonnull GitInfo gitInfo, @Nonnull Collection<TicketInfo> ticketInfo) {
        this.gitInfo = Objects.requireNonNull(gitInfo, "gitInfo");
        this.ticketInfo = Objects.requireNonNull(ticketInfo, "ticketInfo");
    }

    @Nonnull
    public GitInfo getGitInfo() {
        return this.gitInfo;
    }

    @Nonnull
    public Collection<TicketInfo> getTicketInfo() {
        return this.ticketInfo;
    }

    @Nonnull
    public static SupportInfo toSupportInfo(@Nonnull RpcGetSupportInfoResponse supportInfo) {
        Objects.requireNonNull(supportInfo, "supportInfo");
        return new SupportInfo(GitInfo.toGitInfo(supportInfo.getGitInfo()), (Collection)supportInfo.getTicketInfoList().stream().map(TicketInfo::toTicketInfo).collect(ImmutableList.toImmutableList()));
    }
}

