/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mesh.support;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcTicketInfo;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;

public class TicketInfo {
    private final RpcTicketInfo rpc;

    private TicketInfo(@Nonnull RpcTicketInfo rpc) {
        this.rpc = Objects.requireNonNull(rpc, "rpc");
    }

    public int getAvailable() {
        return this.rpc.getAvailable();
    }

    @Nonnull
    public Optional<Instant> getLastRejection() {
        if (this.rpc.hasLastRejection()) {
            return Optional.of(Instant.ofEpochMilli(this.rpc.getLastRejection()));
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<Instant> getOldestQueuedRequest() {
        if (this.rpc.hasOldestQueuedRequest()) {
            return Optional.of(Instant.ofEpochMilli(this.rpc.getOldestQueuedRequest()));
        }
        return Optional.empty();
    }

    public int getQueuedRequests() {
        return this.rpc.getQueuedRequests();
    }

    @Nonnull
    public String getResource() {
        return this.rpc.getResource();
    }

    public int getTotal() {
        return this.rpc.getTotal();
    }

    public int getUsed() {
        return this.rpc.getUsed();
    }

    @Nonnull
    public static TicketInfo toTicketInfo(@Nonnull RpcTicketInfo rpc) {
        return new TicketInfo(rpc);
    }
}

