/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.csp.api.internal;

import com.atlassian.security.csp.api.CspDirective;
import com.atlassian.security.csp.api.CspFragment;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ContentSecurityPolicy {
    public static final String EMPTY_STRING = "";
    public static final String CSP_DIRECTIVE_SEPERATOR = "; ";
    public static final String CSP_DIRECTIVE_VALUES_SEPERATOR = " ";
    public static final String SELF = "'self'";
    public static final String UNSAFE_EVAL = "'unsafe-eval'";
    public static final String UNSAFE_INLINE = "'unsafe-inline'";
    public static final String STRICT_DYNAMIC = "'strict-dynamic'";
    public static final String NONCE_PREFIX = "nonce-";
    private final Map<CspDirective, Set<String>> directives;

    private ContentSecurityPolicy(Builder builder) {
        this.directives = builder.directives;
    }

    private String getDirectiveAsString(CspDirective directive) {
        Set<String> values = this.directives.get(directive);
        if (values == null) {
            return EMPTY_STRING;
        }
        String directiveValue = values.stream().collect(Collectors.joining(CSP_DIRECTIVE_VALUES_SEPERATOR));
        return String.join((CharSequence)CSP_DIRECTIVE_VALUES_SEPERATOR, directive.getDirective(), directiveValue);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ContentSecurityPolicy)) {
            return false;
        }
        ContentSecurityPolicy that = (ContentSecurityPolicy)o;
        return Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.directives);
    }

    public String toString() {
        String policy = this.directives.keySet().stream().map(this::getDirectiveAsString).collect(Collectors.joining(CSP_DIRECTIVE_SEPERATOR, EMPTY_STRING, CSP_DIRECTIVE_SEPERATOR)).trim();
        return policy;
    }

    public void addCspFragment(CspFragment cspFragment) {
        Set fragmentCSPDirectives = cspFragment.getCSPDirectives();
        fragmentCSPDirectives.forEach(t -> this.directives.computeIfAbsent((CspDirective)t, k -> new LinkedHashSet()).addAll(cspFragment.getCSPOrigins(t).stream().map(URI::toString).collect(Collectors.toSet())));
    }

    public static ContentSecurityPolicy parse(String headerValue) {
        String[] parts;
        if (headerValue == null || headerValue.trim().isEmpty()) {
            throw new IllegalArgumentException("Header value must not be null or empty");
        }
        Builder builder = new Builder();
        for (String part : parts = headerValue.split(";")) {
            String[] values;
            String[] directiveParts = part.trim().split(CSP_DIRECTIVE_VALUES_SEPERATOR, 2);
            if (directiveParts.length < 2) {
                throw new IllegalArgumentException("Invalid directive format: " + part);
            }
            for (String value : values = directiveParts[1].split(CSP_DIRECTIVE_VALUES_SEPERATOR)) {
                builder.addToDirective(CspDirective.fromString((String)directiveParts[0]), value);
            }
        }
        return builder.build();
    }

    public static class Builder {
        private final Map<CspDirective, Set<String>> directives = new LinkedHashMap<CspDirective, Set<String>>();

        public Builder addToDirective(CspDirective directive, String value) {
            this.directives.computeIfAbsent(directive, k -> new LinkedHashSet()).add(value);
            return this;
        }

        public Builder addNonce(CspDirective directive, String nonce) {
            if (nonce == null) {
                throw new IllegalStateException("Nonce must be set to add it to a directive");
            }
            this.directives.computeIfAbsent(directive, k -> new HashSet()).add(String.format("'%s%s'", ContentSecurityPolicy.NONCE_PREFIX, nonce));
            return this;
        }

        public ContentSecurityPolicy build() {
            if (this.directives.isEmpty()) {
                throw new IllegalStateException("At least one directive must be set to build a CSP Policy");
            }
            return new ContentSecurityPolicy(this);
        }
    }
}

