/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithCustomAttributes;
import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;
import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.mapper.attribute.ObjectGUIDMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.USNChangedMapper;
import com.atlassian.crowd.model.Tombstone;
import java.util.NoSuchElementException;
import java.util.Set;

public class TombstoneContextMapper
implements ContextMapperWithRequiredAttributes<Tombstone> {
    private final ObjectGUIDMapper objectGUIDMapper = new ObjectGUIDMapper();
    private final USNChangedMapper usnChangedMapper = new USNChangedMapper();

    @Override
    public Tombstone mapFromContext(Object ctx) {
        NameAttributesPair nameAttributesPair = (NameAttributesPair)ctx;
        try {
            String guid = this.objectGUIDMapper.getValues(nameAttributesPair).iterator().next();
            String usnChanged = this.usnChangedMapper.getValues(nameAttributesPair).iterator().next();
            return new Tombstone(guid, usnChanged);
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Could not retrieve objectGUID/uSNChanged due to missing attribute for object: " + String.valueOf(nameAttributesPair.getName()));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve objectGUID/uSNChanged from object: " + String.valueOf(nameAttributesPair.getName()), e);
        }
    }

    @Override
    public Set<String> getRequiredLdapAttributes() {
        return ContextMapperWithCustomAttributes.aggregate(this.objectGUIDMapper, this.usnChangedMapper);
    }
}

