/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.audit;

import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.audit.query.AuditLogQuery;
import com.atlassian.crowd.dao.audit.AssembledAuditLogChangeset;
import com.atlassian.crowd.dao.audit.AuditDao;
import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import com.atlassian.crowd.model.audit.AuditLogEntryEntity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.audit.AuditLogQueryTranslator;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.HqlInClauseBatchHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;

public class AuditDAOHibernate
extends HibernateDao<AuditLogEntryEntity>
implements AuditDao {
    private AuditLogQueryTranslator auditLogQueryTranslator;

    public void add(AuditLogChangesetEntity entry) {
        super.save(entry);
    }

    public <RESULT> List<RESULT> search(AuditLogQuery<RESULT> query) {
        HQLQuery hqlQuery = this.auditLogQueryTranslator.asHQL(query);
        return this.fetchAuditLogEntries(hqlQuery, query.getReturnType());
    }

    private <RESULT> List<RESULT> fetchAuditLogEntries(HQLQuery hqlQuery, Class<RESULT> resultType) {
        List result = this.executeHQLQuery(hqlQuery);
        if (hqlQuery.getResultTransform() == null && resultType.isAssignableFrom(AssembledAuditLogChangeset.class)) {
            List changesets = result;
            Set ids = changesets.stream().map(AuditLogChangesetEntity::getId).collect(Collectors.toSet());
            List csEntities = HqlInClauseBatchHelper.ofHqlQuery(this.session(), "from AuditLogEntityEntity e where e.changeset.id in :changesetIds").query("changesetIds", ids);
            SetMultimap entitiesByCsId = (SetMultimap)csEntities.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(entity -> entity.getChangeset().getId(), Function.identity()));
            List csEntries = HqlInClauseBatchHelper.ofHqlQuery(this.session(), "from AuditLogEntryEntity e where e.changeset.id in :changesetIds").query("changesetIds", ids);
            ImmutableSetMultimap entriesByCsId = (ImmutableSetMultimap)csEntries.stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(entry -> entry.getChangeset().getId(), Function.identity()));
            List collect = (List)changesets.stream().map(cs -> new AssembledAuditLogChangeset((AuditLogChangesetEntity)cs, entitiesByCsId.get((Object)cs.getId()), (Set<AuditLogEntryEntity>)entriesByCsId.get((Object)cs.getId()))).map(resultType.isAssignableFrom(ImmutableAuditLogChangeset.class) ? ImmutableAuditLogChangeset::from : Function.identity()).collect(ImmutableList.toImmutableList());
            return collect;
        }
        return result;
    }

    public int removeChangesetsOlderThan(long timestamp) {
        Query query = this.session().getNamedQuery("removeChangesetsOlderThan");
        query.setParameter("timestamp", (Object)timestamp);
        return query.executeUpdate();
    }

    public long getAuditLogSize() {
        return (Long)this.session().getNamedQuery("getAuditLogSize").uniqueResult();
    }

    @Override
    public Class<AuditLogEntryEntity> getPersistentClass() {
        return AuditLogEntryEntity.class;
    }

    @Autowired
    public void setAuditLogQueryTranslator(AuditLogQueryTranslator auditLogQueryTranslator) {
        this.auditLogQueryTranslator = auditLogQueryTranslator;
    }
}

