/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.audit.processor.impl;

import com.atlassian.crowd.audit.AuditLogAuthor;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.audit.ImmutableAuditLogChangeset;
import com.atlassian.crowd.audit.ImmutableAuditLogEntity;
import com.atlassian.crowd.dao.audit.AuditDao;
import com.atlassian.crowd.dao.audit.processor.MembershipAuditProcessor;
import com.atlassian.crowd.manager.audit.AuditLogChangesetPopulator;
import com.atlassian.crowd.manager.audit.AuditLogMetadataResolver;
import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.util.persistence.hibernate.batch.BulkAuditMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultMembershipAuditProcessor
implements MembershipAuditProcessor {
    private static final Comparator<InternalMembership> MEMBERSHIP_CLASSIFIER = Comparator.comparing(InternalMembership::getParentId);
    private final int maxMembershipAuditBatchSize;
    private final AuditDao auditDao;
    private final AuditLogChangesetPopulator auditLogChangesetPopulator;
    private final AuditLogMetadataResolver auditLogMetadataResolver;

    public DefaultMembershipAuditProcessor(AuditDao auditDao, AuditLogChangesetPopulator auditLogChangesetPopulator, AuditLogMetadataResolver auditLogMetadataResolver, int maxMembershipAuditBatchSize) {
        this.auditDao = auditDao;
        this.auditLogChangesetPopulator = auditLogChangesetPopulator;
        this.auditLogMetadataResolver = auditLogMetadataResolver;
        this.maxMembershipAuditBatchSize = maxMembershipAuditBatchSize;
    }

    @Override
    public void auditMembershipAdded(InternalMembership membership) {
        this.auditMembershipEvent(AuditLogEventType.ADDED_TO_GROUP, membership);
    }

    @Override
    public void auditMembershipRemoved(InternalMembership membership) {
        this.auditMembershipEvent(AuditLogEventType.REMOVED_FROM_GROUP, membership);
    }

    @Override
    public BulkAuditMapper<InternalMembership> auditBulkAddMemberships() {
        AuditLogAuthor author = this.auditLogMetadataResolver.resolveAuthor();
        return memberships -> this.buildMembershipChangesets(author, (Collection<InternalMembership>)memberships, AuditLogEventType.ADDED_TO_GROUP);
    }

    @Override
    public BulkAuditMapper<InternalMembership> auditBulkRemoveMemberships() {
        AuditLogAuthor author = this.auditLogMetadataResolver.resolveAuthor();
        return memberships -> this.buildMembershipChangesets(author, (Collection<InternalMembership>)memberships, AuditLogEventType.REMOVED_FROM_GROUP);
    }

    private List<AuditLogChangesetEntity> buildMembershipChangesets(AuditLogAuthor author, Collection<InternalMembership> memberships, AuditLogEventType eventType) {
        return memberships.stream().sorted(MEMBERSHIP_CLASSIFIER).reduce(new ArrayList(), (lists, internalMembership) -> {
            List<InternalMembership> batch;
            if (this.needsSplit((List<List<InternalMembership>>)lists, (InternalMembership)internalMembership)) {
                batch = new ArrayList();
                lists.add(batch);
            } else {
                batch = (List)lists.get(lists.size() - 1);
            }
            batch.add((InternalMembership)internalMembership);
            return lists;
        }, (first, second) -> ImmutableList.builder().addAll((Iterable)first).addAll((Iterable)second).build()).stream().map(batch -> this.createChangesetForBatch((List<InternalMembership>)batch, author, eventType)).collect(Collectors.toList());
    }

    private boolean needsSplit(List<List<InternalMembership>> lists, InternalMembership next) {
        if (lists.isEmpty()) {
            return true;
        }
        List<InternalMembership> last = lists.get(lists.size() - 1);
        if (last.size() >= this.maxMembershipAuditBatchSize) {
            return true;
        }
        return !last.isEmpty() && MEMBERSHIP_CLASSIFIER.compare(last.get(last.size() - 1), next) != 0;
    }

    private AuditLogChangesetEntity createChangesetForBatch(List<InternalMembership> membership, AuditLogAuthor auditLogAuthor, AuditLogEventType eventType) {
        ImmutableAuditLogChangeset changesetWithAuthor = new ImmutableAuditLogChangeset.Builder(this.prepareAuditLogChangeset(eventType, membership)).setAuthor(auditLogAuthor).build();
        AuditLogChangeset populatedChangeset = this.populateAuditLogChangeset((AuditLogChangeset)changesetWithAuthor);
        return new AuditLogChangesetEntity(populatedChangeset);
    }

    private void auditMembershipEvent(AuditLogEventType eventType, InternalMembership membership) {
        AuditLogChangeset changeset = this.prepareAuditLogChangeset(eventType, Collections.singletonList(membership));
        this.auditDao.add(new AuditLogChangesetEntity(this.populateAuditLogChangeset(changeset)));
    }

    private AuditLogChangeset populateAuditLogChangeset(AuditLogChangeset auditLogChangeset) {
        return this.auditLogChangesetPopulator.populateCommonChangesetProperties(auditLogChangeset, false);
    }

    private AuditLogChangeset prepareAuditLogChangeset(AuditLogEventType eventType, List<InternalMembership> memberships) {
        Preconditions.checkArgument((!memberships.isEmpty() ? 1 : 0) != 0);
        ImmutableAuditLogChangeset.Builder changesetBuilder = new ImmutableAuditLogChangeset.Builder().setEventType(eventType);
        InternalMembership firstMembership = memberships.get(0);
        if (eventType == AuditLogEventType.ADDED_TO_GROUP && firstMembership.getCreatedDate() != null) {
            changesetBuilder.setTimestamp(firstMembership.getCreatedDate());
        }
        ImmutableAuditLogChangeset.Builder changesetBuilderWithMembershipEntities = this.addParentEntityToChangesetBuilder(firstMembership).andThen(this.addChildrenEntitiesToChangesetBuilder(memberships)).andThen(this.addDirectoryEntityToChangesetBuilder(firstMembership)).apply(changesetBuilder);
        return changesetBuilderWithMembershipEntities.build();
    }

    private Function<ImmutableAuditLogChangeset.Builder, ImmutableAuditLogChangeset.Builder> addParentEntityToChangesetBuilder(InternalMembership membership) {
        return changesetBuilder -> changesetBuilder.addEntity(new ImmutableAuditLogEntity.Builder().setEntityId(membership.getParentId()).setEntityName(membership.getParentName()).setEntityType(AuditLogEntityType.GROUP).setPrimary().build());
    }

    private Function<ImmutableAuditLogChangeset.Builder, ImmutableAuditLogChangeset.Builder> addChildrenEntitiesToChangesetBuilder(List<InternalMembership> memberships) {
        return changesetBuilder -> {
            memberships.forEach(membership -> changesetBuilder.addEntity(new ImmutableAuditLogEntity.Builder().setEntityId(membership.getChildId()).setEntityName(membership.getChildName()).setEntityType(membership.getMembershipType() == MembershipType.GROUP_USER ? AuditLogEntityType.USER : AuditLogEntityType.GROUP).build()));
            return changesetBuilder;
        };
    }

    private Function<ImmutableAuditLogChangeset.Builder, ImmutableAuditLogChangeset.Builder> addDirectoryEntityToChangesetBuilder(InternalMembership firstMembership) {
        return changesetBuilder -> changesetBuilder.addEntity(new ImmutableAuditLogEntity.Builder().setEntityId(firstMembership.getDirectory().getId()).setEntityName(firstMembership.getDirectory().getName()).setEntityType(AuditLogEntityType.DIRECTORY).build());
    }
}

