/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.audit.processor.impl;

import com.atlassian.crowd.dao.audit.processor.UserAuditProcessor;
import com.atlassian.crowd.dao.audit.processor.impl.NoopAuditProcessor;
import com.atlassian.crowd.manager.audit.AuditLogEnabledChecker;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.util.persistence.hibernate.batch.BulkAuditMapper;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import org.apache.commons.lang3.builder.DiffResult;

public class DisablableUserAuditProcessor
implements UserAuditProcessor {
    private final NoopAuditProcessor noopAuditProcessor;
    private final UserAuditProcessor userAuditProcessor;
    private final AuditLogEnabledChecker auditLogEnabledChecker;

    public DisablableUserAuditProcessor(NoopAuditProcessor noopAuditProcessor, UserAuditProcessor userAuditProcessor, AuditLogEnabledChecker auditLogEnabledChecker) {
        this.noopAuditProcessor = noopAuditProcessor;
        this.userAuditProcessor = userAuditProcessor;
        this.auditLogEnabledChecker = auditLogEnabledChecker;
    }

    @Override
    public void auditUserAdded(InternalUser user) {
        this.userAuditProcessor().auditUserAdded(user);
    }

    @Override
    public void auditUserRemoved(InternalUser user) {
        this.userAuditProcessor().auditUserRemoved(user);
    }

    @Override
    public void auditUserUpdated(User oldUser, InternalUser updatedUser) {
        this.userAuditProcessor().auditUserUpdated(oldUser, updatedUser);
    }

    @Override
    public void auditCredentialUpdated(InternalUser userToUpdate) {
        this.userAuditProcessor().auditCredentialUpdated(userToUpdate);
    }

    @Override
    public void auditUserAttributesUpdated(InternalUser internalUser, DiffResult<?> changeSet) {
        this.userAuditProcessor().auditUserAttributesUpdated(internalUser, changeSet);
    }

    @Override
    public BulkAuditMapper<TransactionGroup<InternalUser, InternalUserAttribute>> auditBulkAddUsers() {
        return this.userAuditProcessor().auditBulkAddUsers();
    }

    @Override
    public BulkAuditMapper<TransactionGroup<InternalUser, InternalUserAttribute>> auditBulkRemoveUsers() {
        return this.userAuditProcessor().auditBulkRemoveUsers();
    }

    private UserAuditProcessor userAuditProcessor() {
        return this.auditLogEnabledChecker.shouldAuditEvent() ? this.userAuditProcessor : this.noopAuditProcessor;
    }
}

