/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.cluster;

import com.atlassian.crowd.dao.cluster.ClusterInfoDao;
import com.atlassian.crowd.model.cluster.ClusterInfoEntity;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;

public class ClusterInfoDAOHibernate
extends HibernateDao<ClusterInfoEntity>
implements ClusterInfoDao {
    public void store(ClusterInfoEntity clusterInfo) {
        this.saveOrUpdate(clusterInfo);
    }

    public Collection<ClusterInfoEntity> getNodeStatus(Collection<String> nodeIds) {
        if (nodeIds.isEmpty()) {
            return Collections.emptyList();
        }
        Preconditions.checkArgument((!nodeIds.isEmpty() ? 1 : 0) != 0);
        Criteria infoQuery = this.session().createCriteria(ClusterInfoEntity.class).add(Restrictions.in((String)"nodeId", nodeIds));
        return infoQuery.list();
    }

    public int removeStatusNotIn(Collection<String> nodeIds) {
        return this.session().createQuery("delete from ClusterInfoEntity where nodeId not in (:nodeIds)").setParameterList("nodeIds", nodeIds).executeUpdate();
    }

    @Override
    public Class<ClusterInfoEntity> getPersistentClass() {
        return ClusterInfoEntity.class;
    }
}

