/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.cluster;

import com.atlassian.crowd.dao.cluster.ClusterMessageDao;
import com.atlassian.crowd.model.cluster.InternalClusterMessage;
import com.atlassian.crowd.util.persistence.hibernate.StatelessDao;
import java.util.List;
import org.hibernate.query.Query;

public class ClusterMessageDAOHibernate
extends StatelessDao
implements ClusterMessageDao {
    public void addMessage(InternalClusterMessage message) {
        this.withStatelessSession(session -> {
            session.insert((Object)message);
            return null;
        });
    }

    public List<InternalClusterMessage> getMessagesAfter(String excludeNodeId, long fromId) {
        return this.withStatelessSession(session -> {
            Query query = excludeNodeId != null && !excludeNodeId.isEmpty() ? session.createQuery("from InternalClusterMessage where id > :fromId and senderNodeId != :excludeNodeId order by id", InternalClusterMessage.class).setParameter("excludeNodeId", (Object)excludeNodeId) : session.createQuery("from InternalClusterMessage where id > :fromId order by id", InternalClusterMessage.class);
            return query.setParameter("fromId", (Object)fromId).list();
        });
    }

    public int deleteClusterMessagesBeforeAndOn(long toTimestamp) {
        return this.withStatelessSession(session -> session.createQuery("delete from InternalClusterMessage where timestamp <= :toTimestamp").setParameter("toTimestamp", (Object)toTimestamp).executeUpdate());
    }

    public Long getHighestId() {
        return this.withStatelessSession(session -> (Long)session.createQuery("select id from InternalClusterMessage order by id desc").setMaxResults(1).uniqueResult());
    }
}

