/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.directory;

import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.licensing.DirectoryInfoDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.query.DirectoryQueries;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class DirectoryDAOHibernate
extends HibernateDao<DirectoryImpl>
implements DirectoryDao {
    private InternalGroupDao groupDao;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalUserDao userDao;
    private DirectoryInfoDao directoryInfoDao;

    public DirectoryImpl add(Directory directory) {
        DirectoryImpl directoryToPersist = new DirectoryImpl(directory);
        directoryToPersist.setCreatedDateToNow();
        directoryToPersist.setUpdatedDateToNow();
        directoryToPersist.validate();
        super.save(directoryToPersist);
        return directoryToPersist;
    }

    public List<Directory> findAll() {
        return this.search(DirectoryQueries.allDirectories());
    }

    public DirectoryImpl findById(long id) throws DirectoryNotFoundException {
        return (DirectoryImpl)this.load(id, DirectoryNotFoundException::new);
    }

    public DirectoryImpl findByName(String name) throws DirectoryNotFoundException {
        return (DirectoryImpl)this.findByProperty("lowerName", IdentifierUtils.toLowerCase((String)name), DirectoryNotFoundException::new);
    }

    @Override
    public Class<DirectoryImpl> getPersistentClass() {
        return DirectoryImpl.class;
    }

    public void remove(Directory directory) throws DirectoryNotFoundException {
        this.groupDao.removeAll(directory.getId().longValue());
        this.userDao.removeAll(directory.getId().longValue());
        this.directoryInfoDao.removeByDirectoryId(directory.getId());
        super.remove(this.findById(directory.getId()));
    }

    public List<Directory> search(EntityQuery query) {
        Validate.isTrue((query.getEntityDescriptor().getEntityType() == Entity.DIRECTORY ? 1 : 0) != 0, (String)"DirectoryDAO can only evaluate EntityQueries for Entity.DIRECTORY", (Object[])new Object[0]);
        return this.executeHQLQuery(this.hqlQueryTranslater.asHQL(query));
    }

    public DirectoryImpl update(Directory directory) throws DirectoryNotFoundException {
        DirectoryImpl directoryToUpdate = this.findById(directory.getId());
        directoryToUpdate.setUpdatedDateToNow();
        directoryToUpdate.updateDetailsFrom(directory);
        directoryToUpdate.validate();
        super.update(directoryToUpdate);
        return directoryToUpdate;
    }

    @Autowired
    public void setGroupDao(InternalGroupDao groupDao) {
        this.groupDao = groupDao;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setUserDao(InternalUserDao userDao) {
        this.userDao = userDao;
    }

    @Autowired
    public void setDirectoryInfoDao(DirectoryInfoDao directoryInfoDao) {
        this.directoryInfoDao = directoryInfoDao;
    }
}

