/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.licensing;

import com.atlassian.crowd.dao.licensing.DirectoryInfoDao;
import com.atlassian.crowd.dao.licensing.LicensedUserDao;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.licensing.DirectoryInfo;
import com.atlassian.crowd.model.licensing.LicensingSummary;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DirectoryInfoDaoHibernate
extends HibernateDao<DirectoryInfo>
implements DirectoryInfoDao {
    private LicensedUserDao licensedUserDao;

    public DirectoryInfo findById(long id) throws ObjectNotFoundException {
        return (DirectoryInfo)this.load(Long.valueOf(id));
    }

    public void saveOrUpdate(DirectoryInfo directoryInfo) {
        super.saveOrUpdate(directoryInfo);
    }

    public List<DirectoryInfo> findDirectories(LicensingSummary licensingSummary) {
        return this.findByProperties((Map<String, Object>)ImmutableMap.of((Object)"licensingSummary", (Object)licensingSummary)).list();
    }

    public void removeAll(LicensingSummary licensingSummary) {
        this.licensedUserDao.removeAll(licensingSummary);
        this.createDeleteQuery((Map<String, Object>)ImmutableMap.of((Object)"licensingSummary", (Object)licensingSummary)).executeUpdate();
    }

    public void removeByDirectoryId(Long id) {
        this.licensedUserDao.removeByDirectoryId(id);
        this.createDeleteQuery((Map<String, Object>)ImmutableMap.of((Object)"localDirectory.id", (Object)id)).executeUpdate();
    }

    @Autowired
    public void setLicensedUserDao(LicensedUserDao licensedUserDao) {
        this.licensedUserDao = licensedUserDao;
    }

    @Override
    public Class<DirectoryInfo> getPersistentClass() {
        return DirectoryInfo.class;
    }
}

