/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.licensing;

import com.atlassian.crowd.dao.licensing.LicensedUserDao;
import com.atlassian.crowd.dao.licensing.LicensedUsersQuery;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.licensing.LicensedUser;
import com.atlassian.crowd.model.licensing.LicensingSummary;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.query.Query;

public class LicensedUserDaoHibernate
extends HibernateDao<LicensedUser>
implements LicensedUserDao {
    public LicensedUser findById(long id) throws ObjectNotFoundException {
        return (LicensedUser)this.load(Long.valueOf(id));
    }

    public void update(LicensedUser licensedUser) {
        this.saveOrUpdate(licensedUser);
    }

    public void save(List<LicensedUser> licensedUsers) {
        licensedUsers.forEach(this::saveOrUpdate);
        this.session().flush();
        this.session().clear();
    }

    public void remove(LicensedUser licensedUser) {
        this.remove((Object)licensedUser);
    }

    public List<LicensedUser> findLicensedUsers(LicensedUsersQuery query) {
        StringBuilder queryBuilder = new StringBuilder("from LicensedUser user where");
        Query hibernateQuery = this.getQuery(query, queryBuilder, " order by user.lastActive asc, directory.name asc, user.username asc");
        hibernateQuery.setFirstResult(query.getStart());
        if (query.getLimit() > 0) {
            hibernateQuery.setMaxResults(query.getLimit());
        }
        return hibernateQuery.list();
    }

    public Long countLicensedUsers(LicensedUsersQuery query) {
        StringBuilder queryBuilder = new StringBuilder("select count(user.id) from LicensedUser user where");
        Query hibernateQuery = this.getQuery(query, queryBuilder, "");
        return (Long)hibernateQuery.uniqueResult();
    }

    private Query getQuery(LicensedUsersQuery query, StringBuilder queryBuilder, String orderBy) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (query.getDirectoryInfo().isPresent()) {
            queryBuilder.append(" user.directory = :directory");
            params.put("directory", query.getDirectoryInfo().get());
        } else {
            queryBuilder.append(" user.directory.licensingSummary = :licensingSummary");
            params.put("licensingSummary", query.getLicensingSummary());
        }
        if (!Strings.isNullOrEmpty((String)query.getTextSearch())) {
            queryBuilder.append(" and (user.lowerEmail like :search or user.lowerUsername like :search or user.lowerFullName like :search)");
            params.put("search", "%" + query.getTextSearch().toLowerCase() + "%");
        }
        if (query.getLastActiveOnOrBefore().isPresent()) {
            queryBuilder.append(" and user.lastActive <= :lastActiveOnOrBefore");
            params.put("lastActiveOnOrBefore", query.getLastActiveOnOrBefore().get());
        } else if (query.isNeverLoggedIn()) {
            queryBuilder.append(" and user.lastActive is null");
        }
        if (StringUtils.isNotBlank((CharSequence)orderBy)) {
            queryBuilder.append(orderBy);
        }
        Query hibernateQuery = this.session().createQuery(queryBuilder.toString());
        params.entrySet().forEach(entry -> hibernateQuery.setParameter((String)entry.getKey(), entry.getValue()));
        return hibernateQuery;
    }

    public void removeByDirectoryId(Long id) {
        this.removeByDirectoryCondition("directory.localDirectory.id = :argumentId", id);
    }

    public void removeAll(LicensingSummary licensingSummary) {
        this.removeByDirectoryCondition("directory.licensingSummary.id = :argumentId", licensingSummary.getId());
    }

    private void removeByDirectoryCondition(String condition, Object param) {
        this.session().createQuery("delete from LicensedUser user where user.directory.id in (select id from DirectoryInfo directory where " + condition + ")").setParameter("argumentId", param).executeUpdate();
    }

    @Override
    public Class<LicensedUser> getPersistentClass() {
        return LicensedUser.class;
    }
}

