/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.licensing;

import com.atlassian.crowd.dao.licensing.DirectoryInfoDao;
import com.atlassian.crowd.dao.licensing.LicensingSummaryDao;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.ApplicationSubtype;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.licensing.LicensingSummary;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Pair;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;

public class LicensingSummaryDaoHibernate
extends HibernateDao<LicensingSummary>
implements LicensingSummaryDao {
    private DirectoryInfoDao directoryInfoDao;

    public LicensingSummary findById(Long id) throws ObjectNotFoundException {
        return (LicensingSummary)this.load(id);
    }

    public Optional<LicensingSummary> getLicensingSummaryByVersion(Application application, ApplicationSubtype applicationSubtype, long version) {
        Query latestSummaryQuery = this.createQuery((Map<String, Object>)ImmutableMap.of((Object)"application.id", (Object)application.getId(), (Object)"applicationSubtype", (Object)applicationSubtype, (Object)"versionId", (Object)version));
        return latestSummaryQuery.list().stream().findAny();
    }

    public Optional<LicensingSummary> getLatestLicensingSummary(Application application) {
        Query latestSummaryQuery = this.createQuery(this.getPersistentClass(), (Map<String, Object>)ImmutableMap.of((Object)"application.id", (Object)application.getId(), (Object)"active", (Object)true), (List<Pair<String, Boolean>>)ImmutableList.of((Object)Pair.pair((Object)"versionId", (Object)false), (Object)Pair.pair((Object)"applicationSubtype", (Object)false)));
        return latestSummaryQuery.stream().findFirst();
    }

    public List<LicensingSummary> findByApplication(Application application, Long version) {
        Query query = this.createQuery((Map<String, Object>)ImmutableMap.of((Object)"application", (Object)application, (Object)"versionId", (Object)version));
        return this.latest(query.list());
    }

    public Optional<LicensingSummary> findByApplication(Application application, ApplicationSubtype applicationSubtype) {
        return this.latestSingle(this.createApplicationQuery(application, applicationSubtype, true).list());
    }

    private Query<LicensingSummary> createApplicationQuery(Application application, ApplicationSubtype applicationSubtype, boolean active) {
        return this.createQuery((Map<String, Object>)ImmutableMap.of((Object)"application.id", (Object)application.getId(), (Object)"applicationSubtype", (Object)applicationSubtype, (Object)"active", (Object)active));
    }

    public void saveAfterCleanup(LicensingSummary licensingSummary) {
        this.cleanup(licensingSummary, licensingSummary.isActive());
        this.saveOrUpdate(licensingSummary);
    }

    public void activate(LicensingSummary licensingSummary) {
        this.cleanup(licensingSummary, true);
        licensingSummary.setActive(true);
        this.saveOrUpdate(licensingSummary);
    }

    void cleanup(LicensingSummary licensingSummary, boolean active) {
        List<LicensingSummary> toRemove = this.createApplicationQuery(licensingSummary.getApplication(), licensingSummary.getApplicationSubtype(), active).stream().filter(old -> !Objects.equals(old.getId(), licensingSummary.getId())).collect(Collectors.toList());
        if (active) {
            toRemove.removeAll(this.latest(toRemove));
        }
        for (LicensingSummary old2 : toRemove) {
            this.removeCascading(old2);
            this.session().flush();
        }
    }

    private Optional<LicensingSummary> latestSingle(List<LicensingSummary> summaries) {
        List<LicensingSummary> latest = this.latest(summaries);
        return latest.isEmpty() ? Optional.empty() : Optional.of((LicensingSummary)Iterables.getOnlyElement(latest));
    }

    private List<LicensingSummary> latest(List<LicensingSummary> summaries) {
        HashSet unique = new HashSet();
        Stream<LicensingSummary> stream = summaries.stream().sorted(Comparator.comparing(LicensingSummary::getApplicationSubtype).thenComparing(LicensingSummary::getVersionId, Comparator.reverseOrder())).filter(summary -> unique.add(new Pair((Object)summary.getApplication(), (Object)summary.getApplicationSubtype())));
        return stream.collect(Collectors.toList());
    }

    private void removeCascading(LicensingSummary licensingSummary) {
        this.directoryInfoDao.removeAll(licensingSummary);
        this.remove(licensingSummary);
    }

    public void removeByApplicationId(Long id) {
        this.findByProperties((Map<String, Object>)ImmutableMap.of((Object)"application.id", (Object)id)).list().forEach(this::removeCascading);
    }

    @Override
    public Class<LicensingSummary> getPersistentClass() {
        return LicensingSummary.class;
    }

    @Autowired
    public void setDirectoryInfoDao(DirectoryInfoDao directoryInfoDao) {
        this.directoryInfoDao = directoryInfoDao;
    }
}

