/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.membership;

import com.atlassian.crowd.dao.audit.processor.MembershipAuditProcessor;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierMap;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.BoundedCount;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.CrowdCriteriaBatchedInClauseHelperBuilder;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.operation.StatelessInsertOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.operation.StatelessRemoveOperation;
import com.atlassian.hibernate.extras.batching.CriteriaBatchedInClauseHelper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MembershipDAOHibernate
extends HibernateDao<InternalMembership>
implements MembershipDao,
InternalMembershipDao {
    public static final String DIRECTORY_ID = "directory.id";
    public static final String LOWER_PARENT_NAME = "lowerParentName";
    public static final String LOWER_CHILD_NAME = "lowerChildName";
    public static final String MEMBERSHIP_TYPE = "membershipType";
    private InternalGroupDao groupDao;
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalUserDao userDao;
    private MembershipAuditProcessor auditProcessor;

    public BatchResult<InternalMembership> addAll(Set<InternalMembership> memberships) {
        return this.statelessSessionBatchProcessor.execute(new StatelessInsertOperation(), memberships, this.auditProcessor.auditBulkAddMemberships());
    }

    public BatchResult<InternalMembership> removeAll(Set<InternalMembership> memberships) {
        return this.statelessSessionBatchProcessor.execute(new StatelessRemoveOperation(), memberships, this.auditProcessor.auditBulkRemoveMemberships());
    }

    public List<InternalMembership> getMembershipsCreatedAfter(long directoryId, Date timestamp, int maxResults) {
        return this.session().createCriteria(InternalMembership.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add((Criterion)Restrictions.gt((String)"createdDate", (Object)timestamp)).setMaxResults(maxResults).list();
    }

    public BatchResult<String> addAllUsersToGroup(long directoryId, Collection<String> userNames, String groupName) throws GroupNotFoundException {
        Collection internalUsers = this.userDao.findMinimalUsersByNames(directoryId, userNames);
        Collection<String> nonFoundUsers = MembershipDAOHibernate.nonFoundEntities(userNames, internalUsers);
        InternalGroup group = this.groupDao.findByName(directoryId, groupName);
        Date createdDate = new Date(this.timeSource.millis());
        Set<InternalMembership> memberships = internalUsers.stream().map(user -> new InternalMembership(group, user, createdDate)).collect(Collectors.toSet());
        BatchResult result = BatchResult.transform(this.addAll(memberships), InternalMembership::getChildName);
        result.addFailures(nonFoundUsers);
        return result;
    }

    private static <T extends DirectoryEntity> Collection<String> nonFoundEntities(Collection<String> entityNames, Collection<T> foundEntities) {
        if (foundEntities.size() == entityNames.size()) {
            return Collections.emptySet();
        }
        Set foundEntityNames = foundEntities.stream().map(entity -> IdentifierUtils.toLowerCase((String)entity.getName())).collect(Collectors.toSet());
        return ImmutableList.copyOf((Collection)entityNames.stream().filter(entityName -> !foundEntityNames.contains(IdentifierUtils.toLowerCase((String)entityName))).collect(Collectors.toList()));
    }

    public void addGroupToGroup(long directoryId, String childGroup, String parentGroup) throws GroupNotFoundException, MembershipAlreadyExistsException {
        InternalGroup internalChildGroup = this.groupDao.findByName(directoryId, childGroup);
        InternalGroup internalParentGroup = this.groupDao.findByName(directoryId, parentGroup);
        if (this.isGroupDirectMember(directoryId, childGroup, parentGroup)) {
            throw new MembershipAlreadyExistsException(directoryId, childGroup, parentGroup);
        }
        InternalMembership membership = new InternalMembership(internalParentGroup, internalChildGroup, new Date(this.timeSource.millis()));
        super.save(membership);
        this.auditProcessor.auditMembershipAdded(membership);
    }

    public BatchResult<String> addAllGroupsToGroup(long directoryId, Collection<String> childGroupNames, String groupName) throws GroupNotFoundException {
        Collection internalChildGroups = this.groupDao.findByNames(directoryId, childGroupNames);
        InternalGroup parentGroup = this.groupDao.findByName(directoryId, groupName);
        Collection<String> failures = MembershipDAOHibernate.nonFoundEntities(childGroupNames, internalChildGroups);
        Set<InternalMembership> existingMemberships = this.findInternalMemberships(directoryId, childGroupNames, parentGroup.getName(), MembershipType.GROUP_GROUP);
        internalChildGroups = internalChildGroups.stream().filter(childGroup -> {
            if (this.isChildGroupTypeEqualToParentType((InternalGroup)childGroup, parentGroup)) {
                return true;
            }
            failures.add(childGroup.getName());
            return false;
        }).filter(childGroup -> !existingMemberships.stream().anyMatch(membership -> membership.getChildName().equals(childGroup.getName()))).collect(Collectors.toSet());
        Date createdDate = new Date(this.timeSource.millis());
        Set<InternalMembership> memberships = internalChildGroups.stream().map(childGroup -> new InternalMembership(parentGroup, childGroup, createdDate)).collect(Collectors.toSet());
        BatchResult result = BatchResult.transform(this.addAll(memberships), InternalMembership::getChildName);
        result.addFailures(failures);
        return result;
    }

    private boolean isChildGroupTypeEqualToParentType(InternalGroup childGroup, InternalGroup parentGroup) {
        return childGroup.getType().equals((Object)parentGroup.getType());
    }

    private Set<String> findFailedEntities(Collection<String> entities, Collection<String> successfulEntities) {
        return entities.stream().filter(IdentifierUtils.containsIdentifierPredicate(successfulEntities).negate()).collect(Collectors.toSet());
    }

    public BatchResult<String> addUserToGroups(long directoryId, String username, Set<String> groupNames) throws UserNotFoundException {
        if (groupNames.isEmpty()) {
            return new BatchResult(0);
        }
        InternalUser internalUser = this.userDao.findByName(directoryId, username);
        List internalGroups = this.groupDao.search(directoryId, QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).with(Restriction.on((Property)GroupTermKeys.NAME).exactlyMatchingAny(groupNames)).returningAtMost(-1));
        Date createdDate = Date.from(this.timeSource.instant());
        Set<InternalMembership> membershipsToAdd = internalGroups.stream().map(group -> new InternalMembership(group, internalUser, createdDate)).collect(Collectors.toSet());
        BatchResult<InternalMembership> batchResult = this.addAll(membershipsToAdd);
        return BatchResult.transform(batchResult, InternalMembership::getParentName);
    }

    public void addUserToGroup(long directoryId, String username, String groupName) throws UserNotFoundException, GroupNotFoundException, MembershipAlreadyExistsException {
        InternalUser internalUser = this.userDao.findByName(directoryId, username);
        InternalGroup internalGroup = this.groupDao.findByName(directoryId, groupName);
        if (this.isUserDirectMember(directoryId, username, groupName)) {
            throw new MembershipAlreadyExistsException(directoryId, username, groupName);
        }
        InternalMembership membership = new InternalMembership(internalGroup, internalUser, new Date(this.timeSource.millis()));
        super.save(membership);
        this.auditProcessor.auditMembershipAdded(membership);
    }

    public List<InternalMembership> findAll(Collection<Directory> directories) {
        if (directories == null || directories.isEmpty()) {
            return Collections.emptyList();
        }
        return this.session().createCriteria(this.getPersistentClass()).add(Restrictions.in((String)"directory", directories)).list();
    }

    public List<InternalMembership> findAllLocal(Collection<Directory> directories) {
        if (directories == null || directories.isEmpty()) {
            return Collections.emptyList();
        }
        return this.session().createCriteria(this.getPersistentClass()).add(Restrictions.in((String)"directory", directories)).add(Subqueries.propertyIn((String)"parentId", (DetachedCriteria)DetachedCriteria.forClass(InternalGroup.class).add((Criterion)Restrictions.eq((String)"local", (Object)true)).setProjection((Projection)Projections.id()))).list();
    }

    @Override
    public Class<InternalMembership> getPersistentClass() {
        return InternalMembership.class;
    }

    public boolean isGroupDirectMember(long directoryId, String childGroup, String parentGroup) {
        return this.findInternalMembershipOptional(directoryId, childGroup, parentGroup, MembershipType.GROUP_GROUP).isPresent();
    }

    public boolean isUserDirectMember(long directoryId, String username, String groupName) {
        return this.findInternalMembershipOptional(directoryId, username, groupName, MembershipType.GROUP_USER).isPresent();
    }

    public void removeAllRelationships(long directoryId) {
        this.session().getNamedQuery("removeAllRelationships").setLong("directoryId", directoryId).executeUpdate();
    }

    public void removeAllUserRelationships(long directoryId) {
        this.session().getNamedQuery("removeAllRelationshipsOfType").setLong("directoryId", directoryId).setParameter(MEMBERSHIP_TYPE, (Object)MembershipType.GROUP_USER).executeUpdate();
    }

    public void removeGroupFromGroup(long directoryId, String childGroup, String parentGroup) throws MembershipNotFoundException {
        InternalMembership internalMembership = this.findInternalMembership(directoryId, childGroup, parentGroup, MembershipType.GROUP_GROUP);
        super.remove(internalMembership);
        this.auditProcessor.auditMembershipRemoved(internalMembership);
    }

    public BatchResult<String> removeGroupsFromGroup(long directoryId, Collection<String> childGroupNames, String groupName) throws GroupNotFoundException {
        InternalGroup parentGroup = this.groupDao.findByName(directoryId, groupName);
        Set<InternalMembership> existingMemberships = this.findInternalMemberships(directoryId, childGroupNames, parentGroup.getName(), MembershipType.GROUP_GROUP);
        BatchResult result = BatchResult.transform(this.removeAll(existingMemberships), InternalMembership::getChildName);
        result.addFailures(this.findFailedEntities(childGroupNames, result.getSuccessfulEntities()));
        return result;
    }

    public void removeGroupMembers(long directoryId, String groupName) {
        this.session().getNamedQuery("removeAllEntityMembers").setString("entityName", IdentifierUtils.toLowerCase((String)groupName)).setLong("directoryId", directoryId).executeUpdate();
    }

    public void removeGroupMemberships(long directoryId, String groupName) {
        this.session().getNamedQuery("removeAllEntityMemberships").setString("entityName", IdentifierUtils.toLowerCase((String)groupName)).setLong("directoryId", directoryId).setParameter(MEMBERSHIP_TYPE, (Object)MembershipType.GROUP_GROUP).executeUpdate();
    }

    public void removeUserFromGroup(long directoryId, String username, String groupName) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException {
        InternalMembership internalMembership = this.findInternalMembership(directoryId, username, groupName, MembershipType.GROUP_USER);
        super.remove(internalMembership);
        this.auditProcessor.auditMembershipRemoved(internalMembership);
    }

    public BatchResult<String> removeUsersFromGroup(long directoryId, Collection<String> usernames, String groupName) throws GroupNotFoundException {
        InternalGroup group = this.groupDao.findByName(directoryId, groupName);
        Set<InternalMembership> existingMemberships = this.findInternalMemberships(directoryId, usernames, group.getName(), MembershipType.GROUP_USER);
        BatchResult result = BatchResult.transform(this.removeAll(existingMemberships), InternalMembership::getChildName);
        result.addFailures(this.findFailedEntities(usernames, result.getSuccessfulEntities()));
        return result;
    }

    public void removeUserMemberships(long directoryId, String username) {
        this.session().getNamedQuery("removeAllEntityMemberships").setString("entityName", IdentifierUtils.toLowerCase((String)username)).setLong("directoryId", directoryId).setParameter(MEMBERSHIP_TYPE, (Object)MembershipType.GROUP_USER).executeUpdate();
    }

    public void renameGroupRelationships(long directoryId, String oldName, String newName) {
        this.session().getNamedQuery("renameChild").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter(MEMBERSHIP_TYPE, (Object)MembershipType.GROUP_GROUP).executeUpdate();
        this.session().getNamedQuery("renameParent").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter(MEMBERSHIP_TYPE, (Object)MembershipType.GROUP_GROUP).executeUpdate();
        this.session().getNamedQuery("renameParent").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter(MEMBERSHIP_TYPE, (Object)MembershipType.GROUP_USER).executeUpdate();
    }

    public void renameUserRelationships(long directoryId, String oldName, String newName) {
        this.session().getNamedQuery("renameChild").setLong("directoryId", directoryId).setString("oldName", IdentifierUtils.toLowerCase((String)oldName)).setString("newName", newName).setString("lowerNewName", IdentifierUtils.toLowerCase((String)newName)).setParameter(MEMBERSHIP_TYPE, (Object)MembershipType.GROUP_USER).executeUpdate();
    }

    public BoundedCount countDirectMembersOfGroup(long directoryId, String groupName, int potentialMaxCount) {
        Number count = (Number)this.session().getNamedQuery("countMembersOfGroup").setLong("directoryId", directoryId).setString("lowerGroupName", IdentifierUtils.toLowerCase((String)groupName)).setParameter(MEMBERSHIP_TYPE, (Object)MembershipType.GROUP_USER).uniqueResult();
        return BoundedCount.exactly((long)count.longValue());
    }

    public <T> List<T> search(long directoryId, MembershipQuery<T> query) {
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(directoryId, query);
        return this.executeHQLQuery(hqlQuery);
    }

    public <T> Map<String, List<T>> searchGroupedByName(long directoryId, MembershipQuery<T> query) {
        HQLQuery hqlQuery = this.hqlQueryTranslater.asHQL(directoryId, query, true);
        IdentifierMap originalCasing = new IdentifierMap();
        query.getEntityNamesToMatch().forEach(name -> originalCasing.put(name, name));
        ArrayListMultimap results = ArrayListMultimap.create();
        for (Object result : this.executeHQLQuery(hqlQuery)) {
            Object[] resultArr = (Object[])result;
            results.put((Object)((String)originalCasing.getOrDefault(resultArr[0], (Object)((String)resultArr[0]))), resultArr[1]);
        }
        return results.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArrayList((Collection)entry.getValue())));
    }

    @Autowired
    public void setGroupDao(InternalGroupDao groupDao) {
        this.groupDao = groupDao;
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setUserDao(InternalUserDao userDao) {
        this.userDao = userDao;
    }

    private Optional<InternalMembership> findInternalMembershipOptional(long directoryId, String childName, String parentName, MembershipType type) {
        return this.findByPropertiesOptional((Map<String, Object>)ImmutableMap.of((Object)DIRECTORY_ID, (Object)directoryId, (Object)LOWER_PARENT_NAME, (Object)IdentifierUtils.toLowerCase((String)parentName), (Object)LOWER_CHILD_NAME, (Object)IdentifierUtils.toLowerCase((String)childName), (Object)MEMBERSHIP_TYPE, (Object)type));
    }

    private Set<InternalMembership> findInternalMemberships(long directoryId, Collection<String> childNames, String parentName, MembershipType type) {
        CriteriaBatchedInClauseHelper internalMembershipsHelper = CrowdCriteriaBatchedInClauseHelperBuilder.of(InternalMembership.class).withParameter(LOWER_CHILD_NAME).build();
        return new HashSet<InternalMembership>(internalMembershipsHelper.executeAndCollect(this.session(), (Iterable)IdentifierUtils.toLowerCase(childNames), criteria -> {
            criteria.add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId));
            criteria.add((Criterion)Restrictions.eq((String)LOWER_PARENT_NAME, (Object)IdentifierUtils.toLowerCase((String)parentName)));
            criteria.add((Criterion)Restrictions.eq((String)MEMBERSHIP_TYPE, (Object)type));
        }));
    }

    private InternalMembership findInternalMembership(long directoryId, String childName, String parentName, MembershipType type) throws MembershipNotFoundException {
        return this.findInternalMembershipOptional(directoryId, childName, parentName, type).orElseThrow(() -> new MembershipNotFoundException(childName, parentName));
    }

    @Autowired
    public void setAuditProcessor(@Qualifier(value="membershipAuditProcessor") MembershipAuditProcessor auditProcessor) {
        this.auditProcessor = auditProcessor;
    }
}

