/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.rememberme;

import com.atlassian.crowd.dao.rememberme.CrowdRememberMeTokenDAO;
import com.atlassian.crowd.model.rememberme.CrowdRememberMeToken;
import com.atlassian.crowd.model.rememberme.InternalCrowdRememberMeToken;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.persistence.LockModeType;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CrowdRememberMeTokenDAOHibernate
extends HibernateDao<InternalCrowdRememberMeToken>
implements CrowdRememberMeTokenDAO {
    private static final String CREATED_TIME = "createdTime";
    private static final String USED_TIME = "usedTime";
    private static final String SERIES = "series";
    private static final String TOKEN = "token";
    private static final String USERNAME = "username";
    private static final String DIRECTORY_ID = "directoryId";
    private static final String REMOTE_ADDRESS = "remoteAddress";
    private static final String TOKEN_ID = "id";

    public void removeAll() {
        CriteriaBuilder criteriaBuilder = this.session().getCriteriaBuilder();
        CriteriaDelete deleteQuery = criteriaBuilder.createCriteriaDelete(InternalCrowdRememberMeToken.class);
        deleteQuery.from(InternalCrowdRememberMeToken.class);
        this.session().createQuery(deleteQuery).executeUpdate();
    }

    public void refresh(InternalCrowdRememberMeToken token) {
        this.session().refresh((Object)token);
    }

    @Override
    public Class<InternalCrowdRememberMeToken> getPersistentClass() {
        return InternalCrowdRememberMeToken.class;
    }

    public Optional<InternalCrowdRememberMeToken> findByIdExclusiveLock(Long id) {
        return this.findByProperties((Map<String, Object>)ImmutableMap.of((Object)TOKEN_ID, (Object)id)).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResultOptional();
    }

    public List<InternalCrowdRememberMeToken> findTokensForUser(String username, long directoryId) {
        CriteriaBuilder criteriaBuilder = this.session().getCriteriaBuilder();
        CriteriaQuery selectQuery = criteriaBuilder.createQuery(InternalCrowdRememberMeToken.class);
        Root schema = selectQuery.from(InternalCrowdRememberMeToken.class);
        selectQuery.where(new Predicate[]{criteriaBuilder.equal((Expression)schema.get(DIRECTORY_ID), (Object)directoryId), criteriaBuilder.equal((Expression)schema.get(USERNAME), (Object)username)});
        selectQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)schema.get(CREATED_TIME)), criteriaBuilder.desc((Expression)schema.get(USED_TIME))});
        return this.session().createQuery(selectQuery).list();
    }

    public InternalCrowdRememberMeToken save(InternalCrowdRememberMeToken token) {
        super.save(token);
        return token;
    }

    public int removeAllExpiredTokens(LocalDateTime lastValidTokenCreateTime, LocalDateTime lastValidUsedBeforeTime) {
        CriteriaBuilder criteriaBuilder = this.session().getCriteriaBuilder();
        CriteriaDelete deleteQuery = criteriaBuilder.createCriteriaDelete(InternalCrowdRememberMeToken.class);
        Root schema = deleteQuery.from(InternalCrowdRememberMeToken.class);
        deleteQuery.where((Expression)criteriaBuilder.or((Expression)criteriaBuilder.lessThan((Expression)schema.get(CREATED_TIME), (Comparable)lastValidTokenCreateTime), (Expression)criteriaBuilder.lessThan((Expression)schema.get(USED_TIME), (Comparable)lastValidUsedBeforeTime)));
        return this.session().createQuery(deleteQuery).executeUpdate();
    }

    public int removeTokensForSeries(String series) {
        return this.session().createQuery(this.deleteQueryWithProperties((Map<String, Object>)ImmutableMap.of((Object)SERIES, (Object)series))).executeUpdate();
    }

    public Optional<InternalCrowdRememberMeToken> findBySeriesAndToken(@Nonnull String series, @Nonnull String token) {
        return this.findByProperties((Map<String, Object>)ImmutableMap.of((Object)SERIES, (Object)series, (Object)TOKEN, (Object)token)).uniqueResultOptional();
    }

    public int removeTokensForUserInDirectory(String username, long directoryId) {
        return this.session().createQuery(this.deleteQueryWithProperties((Map<String, Object>)ImmutableMap.of((Object)USERNAME, (Object)username, (Object)DIRECTORY_ID, (Object)directoryId))).executeUpdate();
    }

    public int removeTokensForDirectory(long directoryId) {
        return this.session().createQuery(this.deleteQueryWithProperties((Map<String, Object>)ImmutableMap.of((Object)DIRECTORY_ID, (Object)directoryId))).executeUpdate();
    }

    public boolean setUsedByRemoteAddress(CrowdRememberMeToken crowdRememberMeToken) {
        CriteriaBuilder criteriaBuilder = this.session().getCriteriaBuilder();
        CriteriaUpdate updateQuery = criteriaBuilder.createCriteriaUpdate(InternalCrowdRememberMeToken.class);
        Root schema = updateQuery.from(InternalCrowdRememberMeToken.class);
        updateQuery.set(schema.get(USED_TIME), (Object)crowdRememberMeToken.getUsedTime()).set(schema.get(REMOTE_ADDRESS), (Object)crowdRememberMeToken.getRemoteAddress()).where(new Predicate[]{criteriaBuilder.isNull((Expression)schema.get(REMOTE_ADDRESS)), criteriaBuilder.equal((Expression)schema.get(TOKEN_ID), (Object)crowdRememberMeToken.getId()), criteriaBuilder.isNull((Expression)schema.get(USED_TIME))});
        return this.session().createQuery(updateQuery).executeUpdate() == 1;
    }

    private CriteriaDelete<InternalCrowdRememberMeToken> deleteQueryWithProperties(Map<String, Object> properties) {
        CriteriaBuilder criteriaBuilder = this.session().getCriteriaBuilder();
        CriteriaDelete deleteQuery = criteriaBuilder.createCriteriaDelete(InternalCrowdRememberMeToken.class);
        Root schema = deleteQuery.from(InternalCrowdRememberMeToken.class);
        deleteQuery.where(this.toPredicates(properties, criteriaBuilder, schema));
        return deleteQuery;
    }
}

