/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.scheduling;

import com.atlassian.crowd.model.scheduling.InternalClusterJob;
import com.atlassian.crowd.util.persistence.hibernate.StatelessDao;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

public class ClusterJobDAOHibernate
extends StatelessDao {
    public boolean create(InternalClusterJob job) {
        try {
            this.withStatelessSession(session -> {
                session.insert((Object)job);
                return null;
            });
            return true;
        }
        catch (ConstraintViolationException e) {
            return false;
        }
    }

    public InternalClusterJob find(String id) {
        return this.withStatelessSession(session -> (InternalClusterJob)session.get(InternalClusterJob.class, (Serializable)((Object)id)));
    }

    public boolean delete(String id) {
        return this.withStatelessSession(session -> session.getNamedQuery("deleteById").setString("id", id).executeUpdate() == 1);
    }

    public boolean claim(String id, @Nullable Long nextRunTimestamp, long expectedVersion, @Nullable String nodeId) {
        return this.withStatelessSession(session -> session.getNamedQuery("updateNextRunTime").setLong("oldVersion", expectedVersion).setLong("newVersion", expectedVersion + 1L).setString("id", id).setParameter("nextRunTimestamp", (Object)nextRunTimestamp, (Type)LongType.INSTANCE).setString("claimNodeId", nodeId).setLong("claimTimestamp", new Date().getTime()).executeUpdate() == 1);
    }

    public Date getNextRunTime(String id) {
        Long result = (Long)this.withStatelessSession(session -> session.getNamedQuery("getNextRunTime").setString("id", id).uniqueResult());
        return result == null ? null : new Date(result);
    }

    public Long getVersion(String id) {
        return (Long)this.withStatelessSession(session -> session.getNamedQuery("getVersion").setString("id", id).uniqueResult());
    }

    @Nonnull
    public Collection<InternalClusterJob> findByJobRunnerKey(String jobRunnerKey) {
        return this.withStatelessSession(session -> session.getNamedQuery("findJobsByRunnerKey").setString("runnerKey", jobRunnerKey).list());
    }

    @Nonnull
    public Map<String, Date> getIdsToNextRunTimes() {
        return this.withStatelessSession(session -> session.getNamedQuery("findNextRuntimes").list()).stream().collect(Collectors.toMap(row -> (String)row[0], row -> new Date((Long)row[1])));
    }

    @Nonnull
    public Set<String> findAllJobRunnerKeys() {
        return this.withStatelessSession(session -> session.getNamedQuery("findAllJobRunnerKeys").list()).stream().collect(Collectors.toSet());
    }
}

