/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.secret;

import com.atlassian.crowd.model.secret.SealedSecretEntity;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.secrets.api.SealedSecret;
import com.atlassian.secrets.api.SecretDao;
import com.atlassian.secrets.api.SecretServiceException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SealedSecretDaoHibernate
extends HibernateDao<SealedSecretEntity>
implements SecretDao {
    public void put(Set<SealedSecret> sealedSecrets) throws SecretServiceException {
        sealedSecrets.stream().map(SealedSecretEntity::new).forEach(sealedSecretEntity -> this.session().merge(sealedSecretEntity));
    }

    public Optional<SealedSecret> get(String identifier) throws SecretServiceException {
        return this.findByPropertyOptional("identifier", identifier).map(SealedSecretEntity::toSealedSecret);
    }

    public void delete(String identifier) throws SecretServiceException {
        this.loadOptional((Serializable)((Object)identifier)).ifPresent(sealedSecretEntity -> this.session().delete(sealedSecretEntity));
    }

    public Set<String> getIdsForBackend(String backendId) throws SecretServiceException {
        return this.findByProperty("backendId", backendId).stream().map(SealedSecretEntity::getIdentifier).collect(Collectors.toSet());
    }

    @Override
    public Class<SealedSecretEntity> getPersistentClass() {
        return SealedSecretEntity.class;
    }

    public List<SealedSecret> getAll() {
        return this.findAllInternal().stream().map(SealedSecretEntity::toSealedSecret).toList();
    }
}

