/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.service;

import com.atlassian.crowd.dao.service.ServiceAccountManagerDAO;
import com.atlassian.crowd.embedded.api.Page;
import com.atlassian.crowd.embedded.api.PageRequest;
import com.atlassian.crowd.embedded.api.service.ServiceAccount;
import com.atlassian.crowd.embedded.api.service.ServiceAccountQuery;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.service.InternalServiceAccount;
import com.atlassian.crowd.model.service.InternalServiceAccountAuthMethod;
import com.atlassian.crowd.model.service.ResourceRestriction;
import com.atlassian.crowd.search.PageImpl;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.HqlInClauseBatchHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hibernate.query.Query;

public class ServiceAccountManagerDAOHibernate
extends HibernateDao<InternalServiceAccount>
implements ServiceAccountManagerDAO {
    private static final String SERVICE_ACCOUNT_NAME_PREFIX = "service-account";

    public InternalServiceAccount createServiceAccount(InternalServiceAccount serviceAccount) {
        serviceAccount.setId(null);
        serviceAccount.setName(String.format("%s-%s", SERVICE_ACCOUNT_NAME_PREFIX, UUID.randomUUID()));
        serviceAccount.setLowerName(IdentifierUtils.toLowerCase((String)serviceAccount.getName()));
        super.save(serviceAccount);
        return serviceAccount;
    }

    public Optional<InternalServiceAccount> getServiceAccount(Long id) {
        return this.loadOptional(id);
    }

    public Optional<InternalServiceAccount> getServiceAccountByName(String name) {
        String hql = "FROM InternalServiceAccount WHERE lowerName = :name";
        Query query = this.session().createQuery(hql, InternalServiceAccount.class);
        query.setParameter("name", (Object)IdentifierUtils.toLowerCase((String)name));
        return query.uniqueResultOptional();
    }

    public boolean updateServiceAccount(InternalServiceAccount serviceAccountUpdate) {
        Optional<InternalServiceAccount> serviceAccountOptional = this.loadOptional(serviceAccountUpdate.getId());
        serviceAccountOptional.ifPresent(entity -> {
            entity.setActive(serviceAccountUpdate.isActive());
            entity.setDisplayName(serviceAccountUpdate.getDisplayName());
            entity.setDescription(serviceAccountUpdate.getDescription());
            this.updateResourceRestrictions((InternalServiceAccount)entity, serviceAccountUpdate.getResourceRestrictions());
            this.setAuthMethods((InternalServiceAccount)entity, serviceAccountUpdate.getAuthMethods());
            this.session().merge(entity);
        });
        return serviceAccountOptional.isPresent();
    }

    private void updateResourceRestrictions(InternalServiceAccount entity, Set<ResourceRestriction> update) {
        HashSet<ResourceRestriction> existing = entity.getResourceRestrictions();
        if (update == null || update.isEmpty()) {
            if (existing == null) {
                entity.setResourceRestrictions(new HashSet());
                return;
            }
            existing.clear();
            return;
        }
        if (existing == null) {
            existing = new HashSet<ResourceRestriction>();
            entity.setResourceRestrictions(existing);
        }
        existing.removeIf(existingRestriction -> update.stream().noneMatch(updateRestriction -> existingRestriction.getKey().equals(updateRestriction.getKey()) && existingRestriction.getValue().equals(updateRestriction.getValue())));
        for (ResourceRestriction updateRestriction : update) {
            if (!existing.stream().noneMatch(existingRestriction -> existingRestriction.getKey().equals(updateRestriction.getKey()) && existingRestriction.getValue().equals(updateRestriction.getValue()))) continue;
            existing.add(new ResourceRestriction(entity, updateRestriction.getKey(), updateRestriction.getValue()));
        }
    }

    private void setAuthMethods(InternalServiceAccount entity, Set<InternalServiceAccountAuthMethod> authMethods) {
        boolean newAuthMethodsIsNotEmpty;
        boolean currentAuthMethodsIsEmpty = entity.getAuthMethods() == null || entity.getAuthMethods().isEmpty();
        boolean bl = newAuthMethodsIsNotEmpty = authMethods != null && !authMethods.isEmpty();
        if (currentAuthMethodsIsEmpty && newAuthMethodsIsNotEmpty) {
            entity.setAuthMethods(authMethods);
        }
    }

    public boolean deleteServiceAccount(Long id) {
        Optional<InternalServiceAccount> serviceAccount = this.loadOptional(id);
        serviceAccount.ifPresent(this::remove);
        return serviceAccount.isPresent();
    }

    public Page<InternalServiceAccount> findServiceAccounts(ServiceAccountQuery query, PageRequest request) {
        Optional maybeActive = query.getActive();
        String phrase = query.getPhrase().orElse(null);
        boolean hasPhrase = phrase != null && !phrase.isBlank();
        boolean hasActive = maybeActive.isPresent();
        StringBuilder hql = new StringBuilder("FROM InternalServiceAccount");
        HashSet<String> where = new HashSet<String>();
        if (hasActive) {
            where.add("active = :active");
        }
        if (hasPhrase) {
            String phraseCondition = "(lower(displayName) LIKE :phrase OR lower(description) LIKE :phrase)";
            where.add(phraseCondition);
        }
        if (!where.isEmpty()) {
            hql.append(" WHERE ");
            hql.append(String.join((CharSequence)" AND ", where));
        }
        Query daoQuery = this.session().createQuery(hql.toString(), InternalServiceAccount.class);
        maybeActive.ifPresent(active -> daoQuery.setParameter("active", active));
        if (hasPhrase) {
            daoQuery.setParameter("phrase", (Object)("%" + phrase.toLowerCase() + "%"));
        }
        int limit = request.limit();
        int start = request.start();
        daoQuery.setFirstResult(start);
        daoQuery.setMaxResults(limit);
        List results = daoQuery.list();
        Long count = this.count(hql.toString(), query, phrase);
        long totalPages = (count + (long)limit - 1L) / (long)limit;
        long currentPage = start / limit + 1;
        boolean isLastPage = currentPage >= totalPages;
        return new PageImpl(results, start, limit, results.size(), isLastPage);
    }

    private Long count(String hql, ServiceAccountQuery query, String phrase) {
        boolean hasPhrase;
        String hqlCount = "SELECT COUNT(*) " + hql;
        Query countQuery = this.session().createQuery(hqlCount);
        Optional maybeActive = query.getActive();
        maybeActive.ifPresent(active -> countQuery.setParameter("active", active));
        boolean bl = hasPhrase = phrase != null && !phrase.isBlank();
        if (hasPhrase) {
            countQuery.setParameter("phrase", (Object)("%" + phrase.toLowerCase() + "%"));
        }
        return (Long)countQuery.uniqueResult();
    }

    public List<InternalServiceAccountAuthMethod> findAuthMethods(long serviceAccountId) {
        String hql = "FROM InternalServiceAccountAuthMethod m WHERE m.serviceAccount.id = :serviceAccountId ";
        Query query = this.session().createQuery(hql, InternalServiceAccountAuthMethod.class);
        query.setParameter("serviceAccountId", (Object)serviceAccountId);
        return query.getResultList();
    }

    public Optional<InternalServiceAccount> findServiceAccountByAuthMethod(String authId, String authType) {
        String hql = "FROM InternalServiceAccount sa JOIN FETCH sa.authMethods AS am WHERE am.authId = :authId AND am.authType = :authType";
        Query query = this.session().createQuery(hql, InternalServiceAccount.class);
        query.setParameter("authId", (Object)authId);
        query.setParameter("authType", (Object)authType);
        return query.uniqueResultOptional();
    }

    public Map<String, InternalServiceAccount> findServiceAccountsByAuthMethods(Map<String, String> authIdToTypeMap) {
        if (authIdToTypeMap == null || authIdToTypeMap.isEmpty()) {
            return Map.of();
        }
        HashMap<String, InternalServiceAccount> results = new HashMap<String, InternalServiceAccount>();
        Map authIdsByType = authIdToTypeMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        String hql = "SELECT DISTINCT sa FROM InternalServiceAccount sa JOIN FETCH sa.authMethods AS am WHERE am.authId IN (:authIds) AND am.authType = :authType";
        authIdsByType.forEach((authType, ids) -> {
            Consumer<Query> queryConsumer = query -> query.setParameter("authType", authType);
            List<InternalServiceAccount> accounts = HqlInClauseBatchHelper.ofHqlQuery(this.session(), hql).withQueryConsumer(queryConsumer).query("authIds", (Iterable<?>)ids);
            accounts.forEach(account -> account.getAuthMethods().stream().filter(authMethod -> authMethod.getAuthType().equals(authType) && ids.contains(authMethod.getAuthId())).forEach(authMethod -> results.put(authMethod.getAuthId(), (InternalServiceAccount)account)));
        });
        return results;
    }

    public void deleteAuth(ServiceAccount serviceAccount, String authId, String authType) {
        this.session().createQuery("DELETE FROM InternalServiceAccountAuthMethod am WHERE am.serviceAccount.id = :serviceAccountId AND am.authId = :authId AND am.authType = :authType").setParameter("serviceAccountId", (Object)serviceAccount.getId()).setParameter("authId", (Object)authId).setParameter("authType", (Object)authType).executeUpdate();
    }

    @Override
    public Class<InternalServiceAccount> getPersistentClass() {
        return InternalServiceAccount.class;
    }
}

