/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.sso;

import com.atlassian.crowd.dao.sso.ApplicationSamlConfigurationDAO;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.sso.ApplicationSamlConfigurationEntity;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ApplicationSamlConfigurationDAOHibernate
extends HibernateDao<ApplicationSamlConfigurationEntity>
implements ApplicationSamlConfigurationDAO {
    public Optional<ApplicationSamlConfigurationEntity> loadForApplication(Application application) {
        return this.loadOptional(application.getId());
    }

    public Optional<ApplicationSamlConfigurationEntity> findByAssertionConsumerAndAudience(String assertionConsumerUrl, String audience) {
        Map<String, Object> params = this.createParamsMapSkipEmpty("assertionConsumerServiceUrl", assertionConsumerUrl, "audienceUrl", audience);
        return params.isEmpty() ? Optional.empty() : this.findByPropertiesOptional(params);
    }

    private Map<String, Object> createParamsMapSkipEmpty(String ... properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < properties.length; i += 2) {
            if (Strings.isNullOrEmpty((String)properties[i + 1])) continue;
            result.put(properties[i], properties[i + 1]);
        }
        return result;
    }

    public void save(ApplicationSamlConfigurationEntity applicationSamlConfiguration) {
        Optional<ApplicationSamlConfigurationEntity> maybeCurrentConfig = this.loadForApplication((Application)applicationSamlConfiguration.getApplication());
        if (maybeCurrentConfig.isPresent()) {
            ApplicationSamlConfigurationEntity currentConfig = maybeCurrentConfig.get();
            applicationSamlConfiguration.setApplicationId(currentConfig.getApplicationId());
            this.session().merge((Object)applicationSamlConfiguration);
        } else {
            this.session().save((Object)applicationSamlConfiguration);
        }
    }

    @Override
    public Class<ApplicationSamlConfigurationEntity> getPersistentClass() {
        return ApplicationSamlConfigurationEntity.class;
    }

    public List<ApplicationSamlConfigurationEntity> findAll() {
        return this.session().createQuery("from ApplicationSamlConfigurationEntity").list();
    }
}

