/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.token.AuthenticationToken;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.TokenTermKeys;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.LogSuppressingUtil;
import jakarta.persistence.PersistenceException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataRetrievalFailureException;

public class TokenDAOHibernate
extends HibernateDao<Token>
implements TokenDAO {
    private static final Logger LOG = LoggerFactory.getLogger(TokenDAOHibernate.class);
    private final HQLQueryTranslater hqlQueryTranslater;

    public TokenDAOHibernate(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    public Token add(Token token) throws ObjectAlreadyExistsException {
        this.session().flush();
        try {
            LogSuppressingUtil.withSuppressedHibernateLogging(() -> {
                super.save(token);
                this.session().flush();
            });
            return token;
        }
        catch (PersistenceException e) {
            LOG.trace("An exception occurred during saving the object", (Throwable)e);
            throw new ObjectAlreadyExistsException(token.getIdentifierHash());
        }
    }

    public Token findByID(long ID) throws ObjectNotFoundException {
        return (Token)this.load(Long.valueOf(ID));
    }

    public Token findByIdentifierHash(String identifierHash) throws ObjectNotFoundException {
        return (Token)this.findByPropertyOrThrow("identifierHash", identifierHash);
    }

    public Token findByRandomHash(String randomHash) throws ObjectNotFoundException {
        return (Token)this.findByPropertyOrThrow("randomHash", randomHash);
    }

    @Override
    public Class<Token> getPersistentClass() {
        return Token.class;
    }

    public Collection<Token> loadAll() {
        return this.findAllInternal();
    }

    public void remove(Token token) {
        this.session().getNamedQuery("removeToken").setEntity("token", (Object)token).executeUpdate();
        this.session().flush();
    }

    public void remove(long directoryId, String name) {
        this.session().getNamedQuery("removeTokensByDirectoryAndName").setLong("directoryId", directoryId).setString("name", name).executeUpdate();
        this.session().flush();
    }

    public void removeExcept(long directoryId, String name, String exclusionToken) {
        BooleanRestriction restriction = Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)TokenTermKeys.DIRECTORY_ID).exactlyMatching((Object)directoryId), Restriction.on((Property)TokenTermKeys.NAME).exactlyMatching((Object)name)});
        EntityQuery query = QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).with((SearchRestriction)restriction).returningAtMost(-1);
        this.search((EntityQuery<? extends AuthenticationToken>)query).stream().filter(t -> !t.getRandomHash().equals(exclusionToken)).forEach(this::remove);
        this.session().flush();
    }

    public void removeExpiredTokens(Date currentTime, long maxLifeInSeconds) {
        int removed = this.session().getNamedQuery("removeExpiredTokens").setLong("maxLifeInSeconds", maxLifeInSeconds).setLong("currentTime", currentTime.getTime()).executeUpdate();
        this.session().flush();
        this.logger.debug("removeExpiredTokens removed tokens: {}", (Object)removed);
    }

    public void removeAll(long directoryId) {
        this.session().getNamedQuery("removeTokensByDirectory").setLong("directoryId", directoryId).executeUpdate();
        this.session().flush();
    }

    public void removeAll() {
        int removed = this.session().getNamedQuery("removeAllTokens").executeUpdate();
        this.session().flush();
        this.logger.debug("removeAll removed tokens: {}", (Object)removed);
    }

    public void saveAll(Collection<Token> tokens) {
        if (tokens == null) {
            throw new DataRetrievalFailureException("Unable to save an empty collection of tokens");
        }
        for (Token token : tokens) {
            this.save(token);
        }
        this.session().flush();
    }

    public List<AuthenticationToken> search(EntityQuery<? extends AuthenticationToken> query) {
        Validate.isTrue((query.getEntityDescriptor().getEntityType() == Entity.TOKEN ? 1 : 0) != 0, (String)"TokenDAO can only evaluate EntityQueries for Entity.TOKEN", (Object[])new Object[0]);
        return this.executeHQLQuery(this.hqlQueryTranslater.asHQL(query));
    }

    public Token update(Token token) {
        super.update(token);
        return token;
    }
}

