/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.tombstone;

import com.atlassian.crowd.dao.tombstone.TombstoneDao;
import com.atlassian.crowd.model.tombstone.AbstractTombstone;
import com.atlassian.crowd.model.tombstone.AliasTombstone;
import com.atlassian.crowd.model.tombstone.ApplicationTombstone;
import com.atlassian.crowd.model.tombstone.ApplicationUpdatedTombstone;
import com.atlassian.crowd.model.tombstone.EventStreamTombstone;
import com.atlassian.crowd.model.tombstone.GroupMembershipTombstone;
import com.atlassian.crowd.model.tombstone.GroupTombstone;
import com.atlassian.crowd.model.tombstone.UserMembershipTombstone;
import com.atlassian.crowd.model.tombstone.UserTombstone;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class TombstoneDAOHibernate
extends HibernateDao<AbstractTombstone>
implements TombstoneDao {
    public void storeUserTombstones(long directoryId, Collection<String> names) {
        long timestamp = this.timeSource.millis();
        this.storeTombstones(names.stream().map(name -> new UserTombstone(timestamp, name, directoryId))::iterator);
    }

    public void storeGroupTombstones(long directoryId, Collection<String> names) {
        long timestamp = this.timeSource.millis();
        this.storeTombstones(names.stream().map(name -> new GroupTombstone(timestamp, name, directoryId))::iterator);
    }

    public void storeUserMembershipTombstone(long directoryId, String username, String parentGroupName) {
        this.storeTombstones(Collections.singleton(new UserMembershipTombstone(this.timeSource.millis(), username, parentGroupName, directoryId)));
    }

    public void storeGroupMembershipTombstone(long directoryId, String childGroupName, String parentGroupName) {
        this.storeTombstones(Collections.singleton(new GroupMembershipTombstone(this.timeSource.millis(), childGroupName, parentGroupName, directoryId)));
    }

    public void storeEventsTombstoneForDirectory(String reason, long directoryId) {
        this.storeTombstones(Collections.singleton(EventStreamTombstone.createForDirectory((long)this.timeSource.millis(), (long)directoryId, (String)reason)));
    }

    public void storeEventsTombstoneForApplication(long applicationId) {
        this.storeTombstones(Collections.singleton(new ApplicationUpdatedTombstone(this.timeSource.millis(), applicationId)));
    }

    public void storeEventsTombstone(String reason) {
        this.storeTombstones(Collections.singleton(EventStreamTombstone.createGlobal((long)this.timeSource.millis(), (String)reason)));
    }

    public void storeAliasTombstone(long applicationId, String username) {
        this.storeTombstones(Collections.singleton(new AliasTombstone(this.timeSource.millis(), applicationId, username)));
    }

    public <T extends AbstractTombstone> void storeTombstones(Iterable<T> tombstones) {
        tombstones.forEach(tombstone -> this.session().save(tombstone));
    }

    public <T extends AbstractTombstone> List<T> getTombstonesAfter(long after, Collection<Long> directoryIds, Class<T> type) {
        Criteria criteria = this.session().createCriteria(type).add((Criterion)Restrictions.gt((String)"timestamp", (Object)after));
        if (!directoryIds.isEmpty()) {
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.in((String)"directoryId", directoryIds), (Criterion)Restrictions.isNull((String)"directoryId")));
        }
        criteria.addOrder(Order.asc((String)"timestamp"));
        return criteria.list();
    }

    public <T extends ApplicationTombstone> List<T> getTombstonesAfter(long after, Long applicationId, Class<T> type) {
        Criteria criteria = this.session().createCriteria(type).add((Criterion)Restrictions.gt((String)"timestamp", (Object)after));
        criteria.add((Criterion)Restrictions.eq((String)"applicationId", (Object)applicationId));
        criteria.addOrder(Order.asc((String)"timestamp"));
        return criteria.list();
    }

    public int removeAllUpTo(long timestamp) {
        return this.session().createQuery("delete from AbstractTombstone where timestamp <= :timestamp").setParameter("timestamp", (Object)timestamp).executeUpdate();
    }

    @Override
    public Class<AbstractTombstone> getPersistentClass() {
        return AbstractTombstone.class;
    }
}

