/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.user;

import com.atlassian.crowd.dao.audit.processor.UserAuditProcessor;
import com.atlassian.crowd.dao.membership.InternalMembershipDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.user.ImmutableUser;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.model.user.InternalUserWithPasswordLastChanged;
import com.atlassian.crowd.model.user.MinimalUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.HqlInClauseBatchHelper;
import com.atlassian.crowd.util.persistence.hibernate.InternalDirectoryEntityHibernateDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.operation.MergeOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.operation.RemoveUserOperation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.DiffResult;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class UserDAOHibernate
extends InternalDirectoryEntityHibernateDao<InternalUser, InternalUserAttribute>
implements InternalUserDao,
UserDao {
    public static final String EXTERNAL_ID = "externalId";
    public static final String DIRECTORY_ID = "directory.id";
    private HQLQueryTranslater hqlQueryTranslater;
    private InternalMembershipDao membershipDao;
    private DirectoryDao directoryDao;
    private UserAuditProcessor auditProcessor;

    public InternalUser add(User user, PasswordCredential credential) throws DirectoryNotFoundException, UserAlreadyExistsException {
        this.session().flush();
        InternalUser existingUser = this.findByNameInternal(user.getDirectoryId(), user.getName()).orElse(null);
        if (existingUser != null) {
            throw new UserAlreadyExistsException(existingUser.getDirectoryId(), existingUser.getName());
        }
        InternalUser userToAdd = new InternalUser(user, this.getDirectory(user), credential);
        this.updateTimestamps((InternalEntity)userToAdd, true);
        try {
            this.save(userToAdd);
            this.auditProcessor.auditUserAdded(userToAdd);
            this.session().flush();
        }
        catch (PersistenceException e) {
            if (e instanceof ConstraintViolationException || e.getCause() instanceof ConstraintViolationException) {
                throw new UserAlreadyExistsException(user.getDirectoryId(), user.getName());
            }
            throw e;
        }
        return userToAdd;
    }

    public BatchResult<User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        HashSet<TransactionGroup> transactionGroups = new HashSet<TransactionGroup>();
        HashSet<UserTemplateWithCredentialAndAttributes> usersFailedValidation = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                InternalUser userToAdd = new InternalUser((User)user, this.getDirectory((User)user), user.getCredential());
                this.updateTimestamps((InternalEntity)userToAdd, true);
                HashSet attribs = new HashSet();
                for (Map.Entry entry : user.getAttributes().entrySet()) {
                    attribs.addAll(((Set)entry.getValue()).stream().map(value -> new InternalUserAttribute(userToAdd, (String)entry.getKey(), value)).collect(Collectors.toList()));
                }
                transactionGroups.add(new TransactionGroup.Builder((Serializable)userToAdd).withDependantObjects(attribs).build());
            }
            catch (DirectoryNotFoundException | IllegalArgumentException e) {
                this.logger.error("Could not add user <" + user.getName() + ">: " + e.getMessage());
                usersFailedValidation.add(user);
            }
        }
        BatchResult transactionGroupBatchResult = this.batchProcessor.execute(new MergeOperation(), transactionGroups, this.auditProcessor.auditBulkAddUsers());
        BatchResult userBatchResult = BatchResult.transform((BatchResult)transactionGroupBatchResult, TransactionGroup::getPrimaryObject);
        userBatchResult.addFailures(usersFailedValidation);
        return userBatchResult;
    }

    public BatchResultWithIdReferences<User> addAll(Collection<UserTemplateWithCredentialAndAttributes> users) {
        HashSet<TransactionGroup> transactionGroups = new HashSet<TransactionGroup>();
        HashSet<UserTemplateWithCredentialAndAttributes> usersFailedValidation = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                DirectoryImpl directory = this.loadReference(DirectoryImpl.class, user.getDirectoryId());
                InternalUser userToAdd = new InternalUser(user, (Directory)directory);
                HashSet attribs = new HashSet();
                for (Map.Entry entry : user.getAttributes().entrySet()) {
                    attribs.addAll(((Set)entry.getValue()).stream().map(value -> new InternalUserAttribute(userToAdd, (String)entry.getKey(), value)).collect(Collectors.toList()));
                }
                TransactionGroup transactionGroupWithUser = new TransactionGroup.Builder((Serializable)userToAdd).withDependantObjects(attribs).build();
                transactionGroups.add(transactionGroupWithUser);
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Could not add user <" + user.getName() + ">: " + e.getMessage());
                usersFailedValidation.add(user);
            }
        }
        BatchResult transactionBatchResult = this.batchProcessor.execute(new MergeOperation(), transactionGroups);
        BatchResultWithIdReferences userBatchResultWithIdReferences = (BatchResultWithIdReferences)BatchResult.transform((BatchResult)transactionBatchResult, TransactionGroup::getPrimaryObject, () -> new BatchResultWithIdReferences(users.size()));
        userBatchResultWithIdReferences.addFailures(usersFailedValidation);
        for (TransactionGroup user : transactionGroups) {
            userBatchResultWithIdReferences.addIdReference((InternalDirectoryEntity)user.getPrimaryObject());
        }
        return userBatchResultWithIdReferences;
    }

    @Override
    public InternalUser findByName(long directoryId, String username) throws UserNotFoundException {
        return this.findByNameInternal(directoryId, username).orElseThrow(() -> new UserNotFoundException(username));
    }

    public InternalUser findByExternalId(long directoryId, String externalId) throws UserNotFoundException {
        Preconditions.checkNotNull((Object)externalId, (Object)EXTERNAL_ID);
        return (InternalUser)this.findByPropertiesOptional((Map<String, Object>)ImmutableMap.of((Object)DIRECTORY_ID, (Object)directoryId, (Object)EXTERNAL_ID, (Object)externalId)).orElseThrow(() -> UserNotFoundException.forExternalId((String)externalId));
    }

    public Map<String, String> findByExternalIds(long directoryId, Set<String> externalIds) {
        List results = HqlInClauseBatchHelper.ofNamedQuery(this.session(), "findUserNamesByExternalIds").withQueryConsumer(query -> query.setParameter("directoryId", (Object)directoryId)).query("userNames", externalIds);
        return results.stream().collect(Collectors.toMap(tuple -> (String)tuple[0], tuple -> (String)tuple[1]));
    }

    public Collection<InternalUserWithPasswordLastChanged> findUsersForPasswordExpiryNotification(Instant currentTime, Duration passwordMaxChangeTime, Duration remindPeriod, long directoryId, int maxResults) {
        return this.session().getNamedQuery("findUsersForPasswordExpiryNotification").setParameter("currentTime", (Object)currentTime.toEpochMilli()).setParameter("passwordMaxChangeTime", (Object)passwordMaxChangeTime.toMillis()).setParameter("remindPeriod", (Object)remindPeriod.toMillis()).setParameter("directoryId", (Object)directoryId).setMaxResults(maxResults).list();
    }

    public List<InternalUser> findByNumericAttributeRange(String attributeName, long min, long max) {
        return this.session().createQuery("select attribute.user from InternalUserAttribute attribute where attribute.name = :attributeName and attribute.numericValue between :min and :max order by attribute.numericValue asc").setParameter("attributeName", (Object)attributeName).setParameter("min", (Object)min).setParameter("max", (Object)max).list();
    }

    public void setAttribute(Collection<InternalUser> users, String attributeName, String attributeValue) {
        List currentAttributes = HqlInClauseBatchHelper.ofHqlQuery(this.session(), "select attribute from InternalUserAttribute attribute where attribute.name = :attributeName and attribute.user in :users").withQueryConsumer(consumer -> consumer.setParameter("attributeName", (Object)attributeName)).query("users", users);
        HashSet<InternalUser> updatedUsers = new HashSet<InternalUser>();
        for (InternalUserAttribute attribute : currentAttributes) {
            if (!updatedUsers.contains(attribute.getUser())) {
                attribute.setValue(attributeValue);
                this.session().update((Object)attribute);
                updatedUsers.add(attribute.getUser());
                continue;
            }
            this.session().delete((Object)attribute);
        }
        Sets.difference((Set)ImmutableSet.copyOf(users), updatedUsers).forEach(user -> this.session().save((Object)new InternalUserAttribute(user, attributeName, attributeValue)));
        this.session().flush();
    }

    public InternalUserWithAttributes findByNameWithAttributes(long directoryId, String username) throws UserNotFoundException {
        return new InternalUserWithAttributes(this.findByName(directoryId, username));
    }

    public Collection<InternalUser> findByNames(long directoryID, Collection<String> usernames) {
        return this.batchFinder.find(directoryID, usernames, InternalUser.class);
    }

    public Collection<MinimalUser> findMinimalUsersByNames(long directoryId, Collection<String> usernames) {
        return HqlInClauseBatchHelper.ofNamedQuery(this.session(), "findMinimalUsersByNames").withQueryConsumer(query -> query.setParameter("directoryId", (Object)directoryId)).query("userNames", usernames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toList()));
    }

    public Collection<InternalUser> findByIds(Collection<Long> userIds) {
        return HqlInClauseBatchHelper.ofNamedQuery(this.session(), "findUsersByIds").query("userIds", userIds);
    }

    public Set<InternalUserAttribute> findUserAttributes(long userId) {
        return Sets.newHashSet((Iterable)this.session().createCriteria(InternalUserAttribute.class).add((Criterion)Restrictions.eq((String)"user.id", (Object)userId)).list());
    }

    public PasswordCredential getCredential(long directoryId, String username) throws UserNotFoundException {
        return this.findByName(directoryId, username).getCredential();
    }

    public List<PasswordCredential> getCredentialHistory(long directoryId, String username) throws UserNotFoundException {
        return this.findByName(directoryId, username).getCredentialHistory();
    }

    @Override
    public Class<InternalUser> getPersistentClass() {
        return InternalUser.class;
    }

    public void remove(User user) throws UserNotFoundException {
        InternalUser userToRemove = this.findByName(user.getDirectoryId(), user.getName());
        this.membershipDao.removeUserMemberships(user.getDirectoryId(), user.getName());
        this.session().getNamedQuery("removeAllInternalUserAttributes").setEntity("user", (Object)userToRemove).executeUpdate();
        super.remove(userToRemove);
        this.auditProcessor.auditUserRemoved(userToRemove);
    }

    public void removeAll(long directoryId) {
        this.membershipDao.removeAllUserRelationships(directoryId);
        this.session().getNamedQuery("removeInternalUserAttributesInDirectory").setLong("directoryId", directoryId).executeUpdate();
        this.session().getNamedQuery("removeCredentialRecordsInDirectory").setLong("directoryId", directoryId).executeUpdate();
        this.session().getNamedQuery("removeInternalUsersInDirectory").setLong("directoryId", directoryId).executeUpdate();
    }

    public List<String> getAllUsernames(long directoryId) {
        CriteriaBuilder criteriaBuilder = this.session().getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(String.class);
        Root schema = query.from(InternalUser.class);
        query.select((Selection)schema.get("lowerName")).where((Expression)criteriaBuilder.equal((Expression)schema.get("directory").get("id"), (Object)directoryId));
        return this.session().createQuery(query).list();
    }

    public BatchResult<String> removeAllUsers(long directoryId, Set<String> userNames) {
        Collection<InternalUser> users = this.findByNames(directoryId, userNames);
        Set transactionGroups = users.stream().map(user -> new TransactionGroup.Builder((Serializable)user).build()).collect(Collectors.toSet());
        BatchResult batchResult = this.batchProcessor.execute(new RemoveUserOperation(), transactionGroups, this.auditProcessor.auditBulkRemoveUsers());
        return BatchResult.transform((BatchResult)batchResult, entity -> ((InternalUser)entity.getPrimaryObject()).getName());
    }

    @Nonnull
    public Set<String> getAllExternalIds(long directoryId) throws DirectoryNotFoundException {
        this.getDirectory(directoryId);
        return ImmutableSet.copyOf((Collection)this.session().createCriteria(InternalUser.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add(Restrictions.isNotNull((String)EXTERNAL_ID)).setProjection((Projection)Projections.property((String)EXTERNAL_ID)).list());
    }

    public long getUserCount(long directoryId) throws DirectoryNotFoundException {
        this.getDirectory(directoryId);
        return ((Number)this.session().createCriteria(InternalUser.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).setProjection(Projections.rowCount()).uniqueResult()).longValue();
    }

    public Set<Long> findDirectoryIdsContainingUserName(String username) {
        CriteriaBuilder criteriaBuilder = this.session().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Long.class);
        Root internalUser = criteriaQuery.from(InternalUser.class);
        criteriaQuery.select((Selection)internalUser.get("directory").get("id")).where((Expression)criteriaBuilder.equal((Expression)internalUser.get("lowerName"), (Object)IdentifierUtils.toLowerCase((String)username)));
        return ImmutableSet.copyOf((Collection)this.session().createQuery(criteriaQuery).list());
    }

    public void removeAttribute(User user, String attributeName) throws UserNotFoundException {
        InternalUser internalUser = this.findByName(user.getDirectoryId(), user.getName());
        this.updateTimestamps((InternalEntity)internalUser, false);
        this.removeAttribute(internalUser, attributeName);
    }

    public InternalUser rename(User user, String newUsername) throws UserNotFoundException, UserAlreadyExistsException {
        InternalUser userToRename = this.findByName(user.getDirectoryId(), user.getName());
        if (newUsername.equals(userToRename.getName())) {
            return userToRename;
        }
        ImmutableUser oldUser = ImmutableUser.from((User)userToRename);
        String oldName = userToRename.getName();
        InternalUser existingUser = this.findByNameInternal(user.getDirectoryId(), newUsername).orElse(null);
        if (existingUser != null && !userToRename.getId().equals(existingUser.getId())) {
            throw new UserAlreadyExistsException(existingUser.getDirectoryId(), existingUser.getName());
        }
        userToRename.renameTo(newUsername);
        this.updateTimestamps((InternalEntity)userToRename, false);
        super.update(userToRename);
        this.membershipDao.renameUserRelationships(userToRename.getDirectoryId(), oldName, userToRename.getName());
        this.auditProcessor.auditUserUpdated((User)oldUser, userToRename);
        return userToRename;
    }

    public <T> List<T> search(long directoryID, EntityQuery<T> query) {
        Validate.isTrue((query.getEntityDescriptor().getEntityType() == Entity.USER ? 1 : 0) != 0, (String)"UserDAO can only evaluate EntityQueries for Entity.USER", (Object[])new Object[0]);
        return this.executeBatchedQueriesIfNecessary(query, this.hqlQueryTranslater.asHQL(directoryID, query));
    }

    @Autowired
    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    @Autowired
    public void setMembershipDao(InternalMembershipDao internalMembershipDao) {
        this.membershipDao = internalMembershipDao;
    }

    @Autowired
    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    @Override
    public DiffResult removeAttribute(InternalUser user, String attributeName) {
        DiffResult attrChangeDiff = super.removeAttribute(user, attributeName);
        this.auditProcessor.auditUserAttributesUpdated(user, attrChangeDiff);
        return attrChangeDiff;
    }

    public void storeAttributes(User user, Map<String, Set<String>> attributes, boolean updateTimestamp) throws UserNotFoundException {
        InternalUser internalUser = this.findByName(user.getDirectoryId(), user.getName());
        if (updateTimestamp) {
            this.updateTimestamps((InternalEntity)internalUser, false);
        }
        DiffResult attrsChangeDiff = this.storeAttributes(internalUser, attributes);
        this.auditProcessor.auditUserAttributesUpdated(internalUser, attrsChangeDiff);
    }

    public InternalUser update(User user) throws UserNotFoundException {
        InternalUser userToUpdate = this.findByName(user.getDirectoryId(), user.getName());
        ImmutableUser oldUser = ImmutableUser.from((User)userToUpdate);
        List diff = userToUpdate.updateDetailsFrom(user);
        if (diff.isEmpty()) {
            return userToUpdate;
        }
        this.updateTimestamps((InternalEntity)userToUpdate, false);
        String hql = "UPDATE InternalUser SET " + diff.stream().map(f -> f.field + " = :" + f.field).collect(Collectors.joining(", ")) + ", updatedDate = :updatedDate WHERE id = :id";
        Query query = this.session().createQuery(hql);
        diff.forEach(f -> query.setParameter(f.field, f.getter.apply(userToUpdate)));
        query.setParameter("updatedDate", (Object)userToUpdate.getUpdatedDate());
        query.setParameter("id", (Object)userToUpdate.getId());
        query.executeUpdate();
        this.auditProcessor.auditUserUpdated((User)oldUser, userToUpdate);
        return userToUpdate;
    }

    public void updateCredential(User user, PasswordCredential credential, int maxPasswordHistory) throws UserNotFoundException {
        InternalUser userToUpdate = this.findByName(user.getDirectoryId(), user.getName());
        userToUpdate.updateCredentialTo(credential, maxPasswordHistory);
        this.updateTimestamps((InternalEntity)userToUpdate, false);
        super.update(userToUpdate);
        this.auditProcessor.auditCredentialUpdated(userToUpdate);
    }

    @Override
    public void addAttribute(InternalUser user, String attributeName, String attributeValue) {
        InternalUserAttribute attribute = new InternalUserAttribute(user, attributeName, attributeValue);
        this.session().save((Object)attribute);
        user.getAttributes().add(attribute);
    }

    private void addAttributeWhereMissingInDirectory(long directoryId, String attrName, String value) {
        DetachedCriteria usersWithAttribute = DetachedCriteria.forClass(InternalUserAttribute.class).add((Criterion)Restrictions.eq((String)"name", (Object)attrName)).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).setProjection((Projection)Property.forName((String)"user.id"));
        List users = this.session().createCriteria(InternalUser.class).add((Criterion)Restrictions.eq((String)DIRECTORY_ID, (Object)directoryId)).add(Property.forName((String)"id").notIn(usersWithAttribute)).list();
        for (InternalUser user : users) {
            this.addAttribute(user, attrName, value);
        }
    }

    private void deleteRepeatedAttributeInDirectory(long directoryId, String attrName) {
        List attributesToRemove = this.session().getNamedQuery("selectRepeatedAttributeInDirectoryToRemove").setParameter("attrName", (Object)attrName).setParameter("directoryId", (Object)directoryId).list();
        HqlInClauseBatchHelper.ofNamedQuery(this.session(), "removeInternalUserAttributesById").executeUpdate("attrIds", attributesToRemove);
    }

    public void setAttributeForAllInDirectory(long directoryId, String attrName, String value) {
        this.deleteRepeatedAttributeInDirectory(directoryId, attrName);
        this.session().getNamedQuery("updateAttributeForAllUsersInDirectory").setParameter("value", (Object)value).setParameter("lowerValue", (Object)IdentifierUtils.toLowerCase((String)value)).setParameter("attrName", (Object)attrName).setParameter("directoryId", (Object)directoryId).executeUpdate();
        this.session().flush();
        this.session().clear();
        this.addAttributeWhereMissingInDirectory(directoryId, attrName, value);
    }

    private Optional<InternalUser> findByNameInternal(long directoryId, String username) {
        return this.findByPropertiesOptional((Map<String, Object>)ImmutableMap.of((Object)DIRECTORY_ID, (Object)directoryId, (Object)"lowerName", (Object)IdentifierUtils.toLowerCase((String)username)));
    }

    private Directory getDirectory(User user) throws DirectoryNotFoundException {
        Validate.notNull((Object)user.getDirectoryId(), (String)"Cannot add user with null directoryId", (Object[])new Object[0]);
        return this.getDirectory(user.getDirectoryId());
    }

    private Directory getDirectory(long directoryId) throws DirectoryNotFoundException {
        return this.directoryDao.findById(directoryId);
    }

    @Autowired
    public void setAuditProcessor(@Qualifier(value="userAuditProcessor") UserAuditProcessor auditProcessor) {
        this.auditProcessor = auditProcessor;
    }
}

