/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.webhook;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.webhook.WebhookDAO;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.WebhookNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.webhook.Webhook;
import com.atlassian.crowd.model.webhook.WebhookImpl;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class WebhookDAOHibernate
extends HibernateDao<WebhookImpl>
implements WebhookDAO {
    private final ApplicationDAO applicationDAO;

    public WebhookDAOHibernate(ApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    public Webhook findById(Long webhookId) throws WebhookNotFoundException {
        return (Webhook)this.load(webhookId, WebhookNotFoundException::new);
    }

    public Webhook findByApplicationAndEndpointUrl(Application application, String endpointUrl) throws WebhookNotFoundException {
        return (Webhook)this.findByPropertiesOptional((Map<String, Object>)ImmutableMap.of((Object)"application.id", (Object)application.getId(), (Object)"endpointUrl", (Object)endpointUrl)).orElseThrow(() -> new WebhookNotFoundException(application.getId().longValue(), endpointUrl));
    }

    public Webhook add(Webhook webhook) {
        Application applicationImpl;
        try {
            applicationImpl = this.applicationDAO.findById(webhook.getApplication().getId().longValue());
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        WebhookImpl webhookToPersist = new WebhookImpl(webhook);
        webhookToPersist.setApplication(applicationImpl);
        super.save(webhookToPersist);
        return webhookToPersist;
    }

    public void remove(Webhook webhook) throws WebhookNotFoundException {
        Webhook persistentInstance = this.findById(webhook.getId());
        persistentInstance.getApplication().getWebhooks().remove(persistentInstance);
        super.remove(persistentInstance);
    }

    public Iterable<Webhook> findAll() {
        return this.session().createQuery("from WebhookImpl").list();
    }

    public Webhook update(Webhook webhook) throws WebhookNotFoundException {
        WebhookImpl webhookToUpdate = (WebhookImpl)this.load(webhook.getId(), WebhookNotFoundException::new);
        webhookToUpdate.updateDetailsFrom(webhook);
        super.update(webhookToUpdate);
        return webhookToUpdate;
    }

    @Override
    public Class<WebhookImpl> getPersistentClass() {
        return WebhookImpl.class;
    }
}

