/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.crowd.util.persistence.hibernate.HqlInClauseBatchHelper;
import com.atlassian.crowd.util.persistence.hibernate.StatelessDao;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchFinder;
import com.atlassian.crowd.util.persistence.hibernate.batch.SessionBatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.StatelessSessionBatchProcessor;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.atlassian.fugue.Pair;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.query.criteria.internal.OrderImpl;
import org.hibernate.transform.BasicTransformerAdapter;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;

public abstract class HibernateDao<T>
extends StatelessDao {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected BatchFinder batchFinder;
    protected SessionBatchProcessor batchProcessor;
    protected StatelessSessionBatchProcessor statelessSessionBatchProcessor;
    protected Clock timeSource = Clock.systemUTC();
    private static final Splitter PATH_SPLITTER = Splitter.on((String)".").omitEmptyStrings();

    public abstract Class<T> getPersistentClass();

    public T load(Serializable id) throws ObjectNotFoundException {
        T obj = this.loadOptional(id).orElseThrow(() -> new ObjectNotFoundException(this.getPersistentClass(), (Object)id));
        this.logger.trace("Loaded object: {}", obj);
        return obj;
    }

    protected <V extends Serializable, E extends Exception> T load(V id, Function<V, E> exceptionMapper) throws E {
        return this.loadOptional(id).orElseThrow(() -> (Exception)exceptionMapper.apply(id));
    }

    protected Optional<T> loadOptional(Serializable id) {
        return Optional.ofNullable(this.session().get(this.getPersistentClass(), id));
    }

    protected Query<T> findByProperties(Map<String, Object> properties) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getPersistentClass());
        Root root = criteria.from(this.getPersistentClass());
        criteria.select((Selection)root).where(this.toPredicates(properties, builder, root));
        return this.session().createQuery(criteria);
    }

    protected long getCountByProperties(Map<String, Object> properties) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(this.getPersistentClass());
        criteria.select((Selection)builder.count((Expression)root)).where(this.toPredicates(properties, builder, root));
        return (Long)this.session().createQuery(criteria).uniqueResult();
    }

    protected Query<T> findByProperty(String name, Object value) {
        return this.findByProperties((Map<String, Object>)ImmutableMap.of((Object)name, (Object)value));
    }

    protected Optional<T> findByPropertiesOptional(Map<String, Object> properties) {
        return this.findByProperties(properties).uniqueResultOptional();
    }

    protected T findByPropertyOrThrow(String name, Object value) throws ObjectNotFoundException {
        return this.findByPropertyOptional(name, value).orElseThrow(() -> new ObjectNotFoundException(this.getPersistentClass(), value));
    }

    protected Optional<T> findByPropertyOptional(String name, Object value) {
        return this.findByProperty(name, value).uniqueResultOptional();
    }

    protected <V, E extends Exception> T findByProperty(String name, V value, Function<V, E> exceptionMapper) throws E {
        return this.findByPropertyOptional(name, value).orElseThrow(() -> (Exception)exceptionMapper.apply(value));
    }

    protected <T> Query<T> createQuery(Class persistentClass, Map<String, Object> properties, List<Pair<String, Boolean>> orderByProperties) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(persistentClass);
        Root root = criteria.from(persistentClass);
        Predicate[] predicates = this.toPredicates(properties, builder, root);
        CriteriaQuery query = criteria.select((Selection)root).where(predicates);
        if (orderByProperties != null) {
            query.orderBy(orderByProperties.stream().map(pair -> new OrderImpl((Expression)root.get((String)pair.left()), ((Boolean)pair.right()).booleanValue())).collect(Collectors.toList()));
        }
        return this.session().createQuery(query);
    }

    protected <T> Query<T> createQuery(Map<String, Object> properties) {
        return this.createQuery(this.getPersistentClass(), properties, null);
    }

    protected <T> Query<T> createDeleteQuery(Class persistentClass, Map<String, Object> properties) {
        CriteriaBuilder builder = this.session().getCriteriaBuilder();
        CriteriaDelete criteria = builder.createCriteriaDelete(persistentClass);
        Root root = criteria.from(persistentClass);
        Predicate[] predicates = this.toPredicates(properties, builder, root);
        criteria.where(predicates);
        return this.session().createQuery(criteria);
    }

    protected <T> Query<T> createDeleteQuery(Map<String, Object> properties) {
        return this.createDeleteQuery(this.getPersistentClass(), properties);
    }

    protected <T> Predicate[] toPredicates(Map<String, Object> properties, CriteriaBuilder builder, Root<T> root) {
        Predicate[] result = new Predicate[properties.size()];
        int count = 0;
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            Path path = this.getPath((Path)root, entry.getKey());
            if (entry.getValue() instanceof Collection) {
                result[count++] = path.in((Collection)entry.getValue());
                continue;
            }
            result[count++] = builder.equal((Expression)path, entry.getValue());
        }
        return result;
    }

    private Path getPath(Path input, String path) {
        Path out = input;
        for (String part : PATH_SPLITTER.split((CharSequence)path)) {
            out = out.get(part);
        }
        return out;
    }

    public <U> U loadReference(Class<U> persistentClass, long id) {
        return persistentClass.cast(this.session().load(persistentClass, (Serializable)Long.valueOf(id)));
    }

    public T loadReference(long id) {
        return this.loadReference(this.getPersistentClass(), id);
    }

    public void remove(Object persistentObject) throws DataAccessException {
        this.logger.debug("Deleting object: {}", persistentObject);
        this.session().delete(persistentObject);
    }

    public void removeByIdIfPresent(Serializable id) {
        this.loadOptional(id).ifPresent(this::remove);
    }

    public void save(Object persistentObject) throws DataAccessException {
        this.logger.debug("Saving object: {}", persistentObject);
        this.session().save(persistentObject);
    }

    public void saveOrUpdate(Object persistentObject) throws DataAccessException {
        this.logger.debug("Saving or updating object: {}", persistentObject);
        this.session().saveOrUpdate(persistentObject);
    }

    @Autowired
    public void setBatchFinder(BatchFinder batchFinder) {
        this.batchFinder = batchFinder;
    }

    @Autowired
    public void setBatchProcessor(SessionBatchProcessor batchProcessor) {
        this.batchProcessor = batchProcessor;
    }

    @Autowired
    public void setStatelessSessionBatchProcessor(StatelessSessionBatchProcessor statelessSessionBatchProcessor) {
        this.statelessSessionBatchProcessor = statelessSessionBatchProcessor;
    }

    public void update(Object persistentObject) throws DataAccessException {
        this.logger.debug("Updating object: {}", persistentObject);
        this.session().saveOrUpdate(persistentObject);
    }

    protected Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    @SuppressFBWarnings(value={"SQL_INJECTION"}, justification="This gets used all over the place to run queries and we assume that at this point hqlQuery is safe")
    protected <R> List<R> executeHQLQuery(HQLQuery hqlQuery) {
        List<List> batches;
        Query hibernateQuery = this.prepareQuery(hqlQuery);
        if (hqlQuery.getBatchedParamName() != null && (batches = HqlInClauseBatchHelper.splitIntoBatchesList(hqlQuery.getBatchedParamValues())).size() > 1) {
            return this.executeBatchedQuery(hibernateQuery, hqlQuery, batches);
        }
        return hibernateQuery.list();
    }

    private <R> List<R> executeBatchedQuery(Query hibernateQuery, HQLQuery hqlQuery, List<List> batches) {
        hibernateQuery.setFirstResult(0);
        if (hqlQuery.getMaxResults() != -1) {
            hibernateQuery.setMaxResults(hqlQuery.getMaxResults() + hqlQuery.getStartIndex());
        }
        LinkedHashSet uniqueResults = new LinkedHashSet();
        for (List batch : batches) {
            hibernateQuery.setParameterList(hqlQuery.getBatchedParamName(), (Collection)batch);
            uniqueResults.addAll(hibernateQuery.list());
        }
        ArrayList results = new ArrayList(uniqueResults);
        if (hqlQuery.getComparatorForBatch() != null) {
            Collections.sort(results, hqlQuery.getComparatorForBatch());
        }
        return SearchResultsUtil.constrainResults(results, (int)hqlQuery.getStartIndex(), (int)hqlQuery.getMaxResults());
    }

    private Query prepareQuery(final HQLQuery hqlQuery) {
        Query hibernateQuery = this.session().createQuery(hqlQuery.toString());
        hibernateQuery.setReadOnly(hqlQuery.isReadOnly());
        if (hqlQuery.getResultTransform() != null) {
            hibernateQuery.setResultTransformer((ResultTransformer)new BasicTransformerAdapter(){

                public List transformList(List list) {
                    return (List)hqlQuery.getResultTransform().apply(list);
                }
            });
        }
        for (Map.Entry entry : hqlQuery.getParameterMap().entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                hibernateQuery.setParameterList(name, (Collection)value);
                continue;
            }
            hibernateQuery.setParameter(name, value);
        }
        hibernateQuery.setFirstResult(hqlQuery.getStartIndex());
        if (hqlQuery.getMaxResults() != -1) {
            hibernateQuery.setMaxResults(hqlQuery.getMaxResults());
        }
        if (hqlQuery.getCacheRegion() != null) {
            hibernateQuery.setCacheable(true);
            hibernateQuery.setCacheRegion(hqlQuery.getCacheRegion());
        }
        hqlQuery.getFetchSize().ifPresent(arg_0 -> ((Query)hibernateQuery).setFetchSize(arg_0));
        return hibernateQuery;
    }

    public void setClock(Clock timeSource) {
        this.timeSource = timeSource;
    }

    protected List<T> findAllInternal() {
        return this.findByProperties((Map<String, Object>)ImmutableMap.of()).list();
    }
}

