/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.InternalEntityAttribute;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.ComparatorForQueryFactory;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class InternalDirectoryEntityHibernateDao<T extends InternalDirectoryEntity<U>, U extends InternalEntityAttribute>
extends HibernateDao<T> {
    public abstract void addAttribute(T var1, String var2, String var3);

    public DiffResult removeAttribute(T entity, String attributeName) {
        return this.removeMatchingAttributes(entity, attribute -> attribute.getName().equals(attributeName));
    }

    private DiffResult<?> removeMatchingAttributes(T entity, Predicate<U> removePredicate) {
        DiffBuilder diffBuilder = new DiffBuilder((Object)entity.getName(), (Object)entity.getName(), ToStringStyle.SIMPLE_STYLE, false);
        Iterator attributesIterator = entity.getAttributes().iterator();
        HashMap<String, Set> attributesToRemove = new HashMap<String, Set>();
        while (attributesIterator.hasNext()) {
            InternalEntityAttribute attribute = (InternalEntityAttribute)attributesIterator.next();
            if (!removePredicate.test(attribute)) continue;
            attributesToRemove.computeIfAbsent(attribute.getName(), k -> new HashSet()).add(attribute.getValue());
            attributesIterator.remove();
            this.session().delete((Object)attribute);
        }
        attributesToRemove.forEach((attributeName, valuesToRemove) -> diffBuilder.append(attributeName, valuesToRemove, Collections.emptySet()));
        return diffBuilder.build();
    }

    public DiffResult removeAttribute(T entity, String attributeName, String attributeValue) {
        return this.removeMatchingAttributes(entity, attribute -> attribute.getName().equals(attributeName) && attribute.getValue().equals(attributeValue));
    }

    protected void updateTimestamps(InternalEntity entity, boolean updateCreatedDate) {
        Date now = new Date(this.timeSource.millis());
        entity.setUpdatedDate(now);
        if (updateCreatedDate) {
            entity.setCreatedDate(now);
        }
    }

    public abstract T findByName(long var1, String var3) throws ObjectNotFoundException;

    protected DiffResult storeAttributes(T entityWithAttributes, Map<String, Set<String>> attributesToSet) {
        Map existingAttributesMap = entityWithAttributes.getAttributes().stream().collect(Collectors.groupingBy(InternalEntityAttribute::getName, Collectors.mapping(Function.identity(), Collectors.toSet())));
        DiffBuilder diffBuilder = new DiffBuilder((Object)entityWithAttributes.getName(), (Object)entityWithAttributes.getName(), ToStringStyle.SIMPLE_STYLE, false);
        attributesToSet.forEach((attribute, newValues) -> {
            Set existingAttributes = existingAttributesMap.getOrDefault(attribute, Collections.emptySet());
            Set oldValues = existingAttributes.stream().map(InternalEntityAttribute::getValue).collect(Collectors.toSet());
            Set valsToRemove = existingAttributes.stream().filter(existingAttribute -> !newValues.contains(existingAttribute.getValue())).collect(Collectors.toSet());
            ArrayList<String> valsToAdd = new ArrayList<String>((Collection<String>)Sets.difference((Set)newValues, oldValues));
            diffBuilder.append(attribute, oldValues, newValues);
            for (InternalEntityAttribute existingAttribute2 : valsToRemove) {
                if (!valsToAdd.isEmpty()) {
                    String newVal = (String)valsToAdd.remove(0);
                    existingAttribute2.setValue(newVal);
                    this.saveOrUpdate(existingAttribute2);
                    continue;
                }
                this.remove(existingAttribute2);
                entityWithAttributes.getAttributes().remove(existingAttribute2);
            }
            valsToAdd.forEach(value -> this.addAttribute(entityWithAttributes, (String)attribute, (String)value));
        });
        this.session().flush();
        return diffBuilder.build();
    }

    protected <V> List<V> executeBatchedQueriesIfNecessary(EntityQuery<V> entityQuery, List<HQLQuery> hqlQueries) {
        if (hqlQueries.size() == 1) {
            return this.executeHQLQuery(hqlQueries.get(0));
        }
        return hqlQueries.stream().flatMap(query -> this.executeHQLQuery((HQLQuery)query).stream()).sorted(ComparatorForQueryFactory.comparatorForQuery(entityQuery)).skip(entityQuery.getStartIndex()).limit(EntityQuery.allResultsToLongMax((int)entityQuery.getMaxResults())).collect(Collectors.toList());
    }
}

