/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate;

import com.atlassian.config.db.HibernateConfig;
import com.atlassian.crowd.util.persistence.SchemaHelper;
import com.atlassian.crowd.util.persistence.liquibase.CrowdSpringLiquibase;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.changelog.FastCheckService;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiquibaseSchemaHelper
implements SchemaHelper {
    private static final Logger log = LoggerFactory.getLogger(LiquibaseSchemaHelper.class);
    private static final String MASTER_CHANGELOG = "liquibase/crowd-master.xml";
    private static final String DROP_CHANGELOG = "liquibase/drop.xml";
    private final String configFile;
    private final Supplier<Properties> hibernatePropertiesSupplier;

    public LiquibaseSchemaHelper(String configFile, Properties ... partialProps) {
        this(configFile, () -> {
            Properties result = new Properties();
            for (Properties partialProp : partialProps) {
                result.putAll((Map<?, ?>)partialProp);
            }
            return result;
        });
    }

    public LiquibaseSchemaHelper(String configFile, HibernateConfig hibernateConfig) {
        this(configFile, () -> ((HibernateConfig)hibernateConfig).getHibernateProperties());
    }

    private LiquibaseSchemaHelper(String configFile, Supplier<Properties> hibernatePropertiesSupplier) {
        this.configFile = configFile;
        this.hibernatePropertiesSupplier = hibernatePropertiesSupplier;
    }

    public void updateSchemaIfNeeded() {
        this.withServiceRegistry(serviceRegistry -> {
            this.runLiquibaseUpdate((ServiceRegistry)serviceRegistry, MASTER_CHANGELOG);
            return null;
        });
    }

    public void createSchema() {
        this.dropSchema();
        this.updateSchemaIfNeeded();
    }

    @VisibleForTesting
    public void dropSchema() {
        this.withServiceRegistry(serviceRegistry -> {
            this.runLiquibaseUpdate((ServiceRegistry)serviceRegistry, DROP_CHANGELOG, true);
            return null;
        });
    }

    public boolean databaseContainsExistingData(Connection connection) {
        List<String> tableNames;
        try {
            tableNames = this.getExistingTables(connection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        List existingTables = tableNames.stream().filter(table -> {
            boolean bl;
            block8: {
                Statement statement = connection.createStatement();
                try {
                    statement.execute("select count(*) from " + table);
                    bl = true;
                    if (statement == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        return false;
                    }
                }
                statement.close();
            }
            return bl;
        }).collect(Collectors.toList());
        log.debug("Found {} existing Crowd tables in database: {}", (Object)existingTables.size(), existingTables);
        return !existingTables.isEmpty();
    }

    private List<String> getExistingTables(Connection connection) throws SQLException {
        ImmutableList.Builder tables = ImmutableList.builder();
        try (ResultSet resultSet = this.getTables(connection);){
            while (resultSet.next()) {
                tables.add((Object)resultSet.getString("TABLE_NAME"));
            }
        }
        return tables.build();
    }

    private ResultSet getTables(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String catalog = connection.getCatalog();
        String schema = this.getSchemaPattern(connection);
        return databaseMetaData.getTables(catalog, schema, "%", new String[]{"TABLE"});
    }

    private String getSchemaPattern(Connection connection) throws SQLException {
        try {
            return connection.getSchema();
        }
        catch (AbstractMethodError e) {
            return null;
        }
    }

    private void runLiquibaseUpdate(ServiceRegistry registry, String changelogFile) {
        this.runLiquibaseUpdate(registry, changelogFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLiquibaseUpdate(ServiceRegistry registry, String changelogFile, boolean resetDatabaseState) {
        JdbcServices jdbcServices = (JdbcServices)registry.getService(JdbcServices.class);
        JdbcConnectionAccess connectionAccess = jdbcServices.getBootstrapJdbcConnectionAccess();
        try {
            Connection connection = connectionAccess.obtainConnection();
            try {
                Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
                Liquibase liquibase = new Liquibase(changelogFile, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
                liquibase.update(new Contexts(), new LabelExpression());
                if (resetDatabaseState) {
                    ((FastCheckService)Scope.getCurrentScope().getSingleton(FastCheckService.class)).clearCache();
                }
            }
            finally {
                connectionAccess.releaseConnection(connection);
            }
        }
        catch (SQLException | LiquibaseException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> T withServiceRegistry(Function<ServiceRegistryImplementor, T> registryConsumer) {
        return this.withServiceRegistry(registry -> {}, registryConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withServiceRegistry(Consumer<StandardServiceRegistryBuilder> registryBuilderMutator, Function<ServiceRegistryImplementor, T> registryConsumer) {
        Properties hibernateProperties = this.hibernatePropertiesSupplier.get();
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().configure(this.configFile).applySettings((Map)hibernateProperties);
        registryBuilderMutator.accept(registryBuilder);
        ServiceRegistryImplementor registry = (ServiceRegistryImplementor)registryBuilder.build();
        try {
            T t = registryConsumer.apply(registry);
            return t;
        }
        finally {
            registry.destroy();
        }
    }

    static {
        CrowdSpringLiquibase.init();
    }
}

