/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5;

import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;
import com.atlassian.crowd.util.persistence.hibernate.batch.StatelessSessionBatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate5.AbstractHibernateBatchProcessor;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;

public class Hibernate5StatelessSessionBatchProcessor
extends AbstractHibernateBatchProcessor<StatelessSession>
implements StatelessSessionBatchProcessor {
    private static final ThreadLocal<StatelessSession> currentSessionHolder = new ThreadLocal();

    public Hibernate5StatelessSessionBatchProcessor(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    protected void auditOperations(List<AuditLogChangesetEntity> changesetEntities) {
        changesetEntities.forEach(arg_0 -> ((StatelessSession)this.getSession()).insert(arg_0));
        changesetEntities.stream().flatMap(entity -> entity.getEntities().stream()).forEach(arg_0 -> ((StatelessSession)this.getSession()).insert(arg_0));
        changesetEntities.stream().flatMap(entity -> entity.getEntries().stream()).forEach(arg_0 -> ((StatelessSession)this.getSession()).insert(arg_0));
    }

    protected StatelessSession getSession() {
        return currentSessionHolder.get();
    }

    @Override
    protected void clearSession() {
    }

    @Override
    protected void closeSession() {
        StatelessSession currentSession = currentSessionHolder.get();
        if (currentSession != null) {
            this.log.debug("close session [{}]", (Object)currentSession);
            currentSession.close();
        }
        currentSessionHolder.remove();
    }

    @Override
    protected void flushSession() {
    }

    @Override
    protected StatelessSession openSession() {
        if (currentSessionHolder.get() != null) {
            throw new IllegalStateException("session already open");
        }
        StatelessSession session = this.sessionFactory.openStatelessSession();
        currentSessionHolder.set(session);
        this.log.debug("open new session [{}]", (Object)currentSessionHolder.get());
        return session;
    }
}

