/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.connection;

import com.atlassian.crowd.util.persistence.hibernate.connection.jdbc.ConnectionRefusedException;
import com.atlassian.crowd.util.persistence.hibernate.connection.jdbc.ConnectionTracker;
import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingConnectionProvider
implements ConnectionProvider,
Stoppable,
Configurable,
ServiceRegistryAwareService {
    private static final Logger logger = LoggerFactory.getLogger(DelegatingConnectionProvider.class);
    private ConnectionTracker connectionTracker;
    private ConnectionProvider delegate;
    private volatile String refusalReason;
    private Map configurationValues;

    public DelegatingConnectionProvider(ConnectionProvider delegate, ConnectionTracker connectionTracker) {
        this.delegate = (ConnectionProvider)Preconditions.checkNotNull((Object)delegate, (Object)"Delegated connection provider cannot be null");
        this.connectionTracker = (ConnectionTracker)Preconditions.checkNotNull((Object)connectionTracker, (Object)"Connection tracker cannot be null");
    }

    public Connection getConnection() throws SQLException {
        if (this.refusalReason != null) {
            throw new ConnectionRefusedException(this.refusalReason);
        }
        return this.connectionTracker.track(this.delegate.getConnection());
    }

    public void closeConnection(Connection conn) throws SQLException {
        this.delegate.closeConnection(conn);
    }

    public boolean supportsAggressiveRelease() {
        return this.delegate.supportsAggressiveRelease();
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return this.delegate.isUnwrappableAs(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        return (T)this.delegate.unwrap(unwrapType);
    }

    public void stop() {
        logger.info("Shutting down delegated connection provider: {}", (Object)this.delegate);
        ((Stoppable)this.delegate).stop();
    }

    public void configure(Map configurationValues) {
        this.configurationValues = Collections.unmodifiableMap(new HashMap(configurationValues));
        logger.info("Configuring delegated connection provider: {}", (Object)this.delegate);
        ((Configurable)this.delegate).configure(configurationValues);
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        ((ServiceRegistryAwareService)this.delegate).injectServices(serviceRegistry);
    }

    public synchronized void restart() {
        logger.info("Restarting connection pool");
        this.configure(this.configurationValues);
        this.refusalReason = null;
    }

    public synchronized void shutdown(String refusalReason) {
        this.refusalReason = refusalReason;
        logger.info("Shutting down connection pool");
        this.stop();
    }
}

