/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.connection.jdbc;

import com.atlassian.crowd.util.persistence.hibernate.connection.jdbc.ConnectionTracker;
import com.atlassian.crowd.util.persistence.hibernate.connection.jdbc.util.ReferenceBuilder;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyConnectionTracker
implements ConnectionTracker {
    private final Map<SoftReference<Connection>, Thread> leasedConnections = new ConcurrentHashMap<SoftReference<Connection>, Thread>();
    private final ReferenceBuilder referenceBuilder;
    public static final Logger logger = LoggerFactory.getLogger(ProxyConnectionTracker.class);

    public ProxyConnectionTracker() {
        this(new ReferenceBuilder());
    }

    @VisibleForTesting
    public ProxyConnectionTracker(ReferenceBuilder referenceBuilder) {
        this.referenceBuilder = referenceBuilder;
    }

    @Override
    public int getConnectionCount() {
        return this.leasedConnections.size();
    }

    @Override
    public void forEach(BiConsumer<Connection, Thread> biConsumer) {
        this.leasedConnections.forEach((? super K reference, ? super V thread) -> {
            Connection connection = (Connection)reference.get();
            if (connection != null) {
                biConsumer.accept(connection, (Thread)thread);
            } else {
                this.leasedConnections.remove(reference);
                logger.warn("Connection held by thread: {} has been closed unexpectedly by the underlying implementation", (Object)thread.getId());
            }
        });
    }

    @Override
    @Nonnull
    public Connection track(@Nonnull Connection connection) {
        return this.getProxiedConnection(connection);
    }

    @Nonnull
    private Connection getProxiedConnection(Connection actualConnection) {
        ConnectionInvocationHandler invocationHandler = new ConnectionInvocationHandler(actualConnection);
        ClassLoader classLoader = invocationHandler.getClass().getClassLoader();
        Class[] implementingInterfaces = new Class[]{Connection.class};
        Object proxy = Proxy.newProxyInstance(classLoader, implementingInterfaces, (InvocationHandler)invocationHandler);
        return (Connection)Connection.class.cast(proxy);
    }

    private class ConnectionInvocationHandler
    implements InvocationHandler {
        private SoftReference<Connection> delegate;

        public ConnectionInvocationHandler(Connection delegate) {
            this.delegate = ProxyConnectionTracker.this.referenceBuilder.build(delegate);
            ProxyConnectionTracker.this.leasedConnections.put(this.delegate, Thread.currentThread());
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Connection connection = this.delegate.get();
                if (connection != null) {
                    Object object = method.invoke((Object)connection, args);
                    return object;
                }
                try {
                    throw new SQLException("Connection has been closed unexpectedly");
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            finally {
                if ("close".equals(method.getName())) {
                    ProxyConnectionTracker.this.leasedConnections.remove(this.delegate);
                }
            }
        }
    }
}

