/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.liquibase;

import com.atlassian.crowd.util.persistence.liquibase.ext.HibernateUtil;
import java.util.Properties;
import liquibase.Liquibase;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;

public class CrowdSpringLiquibase
extends SpringLiquibase {
    public static final String MASTER_CHANGELOG = "liquibase/crowd-master.xml";
    public static final String DATABASE_CHANGELOG_TABLE_NAME = "CWD_DATABASECHANGELOG";
    public static final String DATABASE_CHANGELOG_LOCK_TABLE_NAME = "CWD_DATABASECHANGELOGLOCK";
    private Properties hibernateProperties;

    public static void init() {
        GlobalConfiguration lbConfig = (GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class);
        lbConfig.setDatabaseChangeLogTableName(DATABASE_CHANGELOG_TABLE_NAME);
        lbConfig.setDatabaseChangeLogLockTableName(DATABASE_CHANGELOG_LOCK_TABLE_NAME);
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties = hibernateProperties;
    }

    protected void performUpdate(Liquibase liquibase) throws LiquibaseException {
        HibernateUtil.getInstance().setHibernateProperties(this.hibernateProperties);
        try {
            super.performUpdate(liquibase);
        }
        finally {
            HibernateUtil.getInstance().clearHibernateProperties();
        }
    }

    static {
        CrowdSpringLiquibase.init();
    }
}

