/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.liquibase.ext;

import com.atlassian.config.util.BootstrapUtils;
import java.util.Optional;
import java.util.Properties;

public class HibernateUtil {
    private ThreadLocal<Properties> hibernateProperties = new ThreadLocal();

    private HibernateUtil() {
    }

    public Object getHibernateDialect(Object fallbackDialect) {
        return this.getDialectFromHibernateProperties().orElseGet(() -> this.getDialectFromBootstrapManager().orElse(fallbackDialect));
    }

    public static HibernateUtil getInstance() {
        return Holder.INSTANCE;
    }

    private Optional<Object> getDialectFromHibernateProperties() {
        return Optional.ofNullable(this.hibernateProperties.get()).map(p -> p.getProperty("hibernate.dialect"));
    }

    private Optional<Object> getDialectFromBootstrapManager() {
        return Optional.ofNullable(BootstrapUtils.getBootstrapManager()).map(p -> p.getProperty("hibernate.dialect"));
    }

    public void clearHibernateProperties() {
        this.hibernateProperties.set(null);
    }

    public void setHibernateProperties(Properties hibernateProperties) {
        this.hibernateProperties.set(hibernateProperties);
    }

    private static class Holder {
        static final HibernateUtil INSTANCE = new HibernateUtil();

        private Holder() {
        }
    }
}

