/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.liquibase.ext;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.HsqlDatabase;
import liquibase.exception.DatabaseException;
import liquibase.structure.core.Column;
import org.apache.commons.lang3.tuple.Pair;

public class NonSchemaSupportingHsqlDb
extends HsqlDatabase {
    private static final Set<Pair<String, String>> LEGACY_LOWERCASE_COLUMN_NAMES = ImmutableSet.of((Object)Pair.of((Object)"REMOTEPRINCIPALCREDENTIALS", (Object)"index"));

    public boolean supportsSchemas() {
        try {
            return this.getDatabaseMajorVersion() >= 2 && super.supportsSchemas();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    public int getPriority() {
        return 2;
    }

    public String escapeColumnName(String catalogName, String schemaName, String tableName, String columnName) {
        if (this.isLegacyLowerColumn(tableName, columnName) && this.requiresQuoting(columnName)) {
            return this.quoteObject(columnName, Column.class);
        }
        return super.escapeColumnName(catalogName, schemaName, tableName, columnName);
    }

    boolean isLegacyLowerColumn(String tableName, String columnName) {
        return LEGACY_LOWERCASE_COLUMN_NAMES.contains(Pair.of((Object)tableName, (Object)columnName));
    }

    boolean requiresQuoting(String columnName) {
        return this.quotingStrategy == ObjectQuotingStrategy.QUOTE_ALL_OBJECTS || this.mustQuoteObjectName(columnName, Column.class);
    }
}

