/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.liquibase.ext.datatype.legacyhibernate;

import liquibase.database.Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.BigIntType;

@DataTypeInfo(name="hbigint", minParameters=0, maxParameters=0, priority=1)
public class HibernateBigIntType
extends BigIntType {
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("NUMBER", new Object[]{19, 0});
        }
        if (database instanceof MSSQLDatabase) {
            return new DatabaseDataType(database.escapeDataTypeName("NUMERIC"), new Object[]{19, 0});
        }
        if (database instanceof PostgresDatabase || database instanceof MySQLDatabase || database instanceof HsqlDatabase) {
            return new DatabaseDataType("BIGINT");
        }
        throw new IllegalStateException("Unsupported database: " + String.valueOf(database));
    }
}

