/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git;

import com.atlassian.bitbucket.repository.RefOrder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum GitRefPattern {
    HEADS(new String[]{"refs", "heads"}){

        @Override
        @Nonnull
        public String sort(@Nullable RefOrder order) {
            if (order == RefOrder.ALPHABETICAL) {
                return this.defaultSort();
            }
            return "-committerdate";
        }
    }
    ,
    PULL_REQUESTS("refs", "pull-requests"),
    REMOTES("refs", "remotes"),
    TAGS(new String[]{"refs", "tags"}){

        @Override
        @Nonnull
        public String sort(@Nullable RefOrder order) {
            if (order == RefOrder.ALPHABETICAL) {
                return this.defaultSort();
            }
            return "-creatordate";
        }
    };

    private final String[] components;
    private final String path;

    private GitRefPattern(String ... components) {
        this.components = components;
        StringBuilder builder = new StringBuilder(50);
        for (String component : components) {
            builder.append(component).append("/");
        }
        this.path = builder.toString();
    }

    @Nonnull
    public String[] getComponents() {
        return (String[])this.components.clone();
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public String getRefspec() {
        return this.getRefspec(false);
    }

    @Nonnull
    public String getRefspec(boolean force) {
        String refspec = this.path + "*";
        StringBuilder builder = new StringBuilder();
        if (force) {
            builder.append("+");
        }
        builder.append(refspec).append(":").append(refspec);
        return builder.toString();
    }

    @Nonnull
    public List<String> getSearchOrder(@Nonnull String ref) {
        String qualified = this.qualify(ref);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)qualified);
        String prefixed = this.path + ref;
        if (!qualified.equals(prefixed)) {
            builder.add((Object)prefixed);
        }
        return builder.build();
    }

    @Nonnull
    public String qualify(@Nonnull String ref) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)Objects.requireNonNull(ref, "ref")), (Object)"No ref was provided to qualify");
        if (ref.indexOf(47) > 0) {
            int index = 0;
            do {
                if (!ref.startsWith(this.path.substring(index))) continue;
                return this.path.substring(0, index) + ref;
            } while ((index = this.path.indexOf(47, index) + 1) < this.path.length());
        }
        return this.path + ref;
    }

    public String sort(@Nullable RefOrder order) {
        return this.defaultSort();
    }

    @Nonnull
    public String unqualify(@Nonnull String ref) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)Objects.requireNonNull(ref, "ref")), (Object)"No ref was provided to unqualify");
        if (ref.indexOf(47) > 0) {
            int index = 0;
            do {
                if (!ref.startsWith(this.path.substring(index))) continue;
                return ref.substring(this.path.length() - index);
            } while ((index = this.path.indexOf(47, index) + 1) < this.path.length());
        }
        return ref;
    }

    protected String defaultSort() {
        return "refname";
    }
}

