/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.git.command.archive;

import com.atlassian.bitbucket.content.ArchiveFormat;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public enum GitArchiveFormat {
    TAR("tar", "application/x-tar"),
    TAR_GZ("tar.gz"),
    TGZ("tgz"),
    ZIP("zip");

    private final String contentType;
    private final String extension;

    private GitArchiveFormat(String extension) {
        this(extension, "application/octet-stream");
    }

    private GitArchiveFormat(String extension, String contentType) {
        this.contentType = contentType;
        this.extension = extension;
    }

    @Nonnull
    public static GitArchiveFormat fromArchiveFormat(@Nonnull ArchiveFormat format) {
        switch (Objects.requireNonNull(format, "archiveFormat")) {
            case TAR: {
                return TAR;
            }
            case TAR_GZ: {
                return TAR_GZ;
            }
            case ZIP: {
                return ZIP;
            }
        }
        throw new IllegalArgumentException(String.valueOf(format) + " is not supported by git archive");
    }

    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    @Nonnull
    public String getExtension() {
        return this.extension;
    }
}

